package org.eclipse.cosmos.me.internal.deployment.sdd.common.validation;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDDManager;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.ValidationFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XML_DAS;

public class ValidationFactoryImpl implements ValidationFactory {	
	private static ValidationFactoryImpl defaultInstance = null;
	
	public static ValidationFactory getDefaultInstance() {
		if (defaultInstance == null) {
			defaultInstance = new ValidationFactoryImpl();
		}
		
		return defaultInstance;
	}

	public SDDManager createSDDManager() {
		return new SDDManagerImpl();
	}

	public SDD_DAS createSDD_DAS() {
		return new SDD_DASImpl();
	}

	public XML_DAS createXML_DAS() {
		return new XML_DASImpl();
	}
}
