/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;



public class VersionRangeType {
	
	public static VersionRange mergeVersionRange( VersionRange versionRange1, VersionRange versionRange2){
		//currently a shell
		if( equals( versionRange1, versionRange2)){
			return versionRange1;
		}
		
		return versionRange1;
	}
	
	public static Boolean equals(VersionRange versionRange1, VersionRange versionRange2){
		
		boolean equals = false;
		
		if( versionRange1.getMaximumVersionInclusiveness() == versionRange2.getMaximumVersionInclusiveness()){
			if( versionRange1.getMaximumVersion() == versionRange2.getMaximumVersion()){
				equals = true;
			}
		}
		
		if( !VersionType.equals(versionRange1.getMinimumVersion(), versionRange2.getMinimumVersion())){
			equals = false;
		}

		return equals;
	}

}
