/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces;

import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.QueryServiceProjectConfig;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.RegistrationServiceProjectConfig;

/**
 * Factory for creating common artifacts for the toolkit
 * 
 * 
 * @author David Whiteman
 */
public class ToolkitArtifactFactory {
	/**
	 * Answer a new instance of a project config for the input type
	 * @param type
	 * @return
	 */
	public static IProjectConfig createProjectConfig(int type) {
		switch (type) {
		case IProjectConfig.QUERY_SERVICE:
			return new QueryServiceProjectConfig();
		case IProjectConfig.REGISTRATION_SERVICE:
			return new RegistrationServiceProjectConfig();

		default:
			break;
		}
		return null;
	}
	
}
