/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.MaintenanceInformationImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ManufacturerInformationImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.w3c.dom.Element;

public class IdentityImpl
extends NameableObject
implements Identity,
Cloneable {
    private static final String IDENTITY_TYPE = "sdd-common:IdentityType";

    public IdentityImpl(Element data, SPISessionImpl session) {
        super(data, session, IDENTITY_TYPE);
    }

    public IdentityImpl(Element data, SPISessionImpl session, String sddSchemaType) {
        super(data, session, sddSchemaType);
    }

    public String getBuildID() {
        String buildAttribute;
        String buildID = null;
        if (this.isSetElement("BuildInformation") && (buildAttribute = this.getChild("BuildInformation").getAttribute("buildID")) != null && buildAttribute.length() > 0) {
            buildID = buildAttribute;
        }
        return buildID;
    }

    public ManufacturerInformation getManufacturerInformation() {
        ManufacturerInformationImpl information = null;
        if (this.isSetElement("Manufacturer")) {
            Element manu = this.getChild("Manufacturer");
            information = new ManufacturerInformationImpl(manu, this.session);
        }
        return information;
    }

    public String getVersion() {
        String value = null;
        if (this.isSetElement("version")) {
            value = this.getChild("version").getTextContent();
        }
        return value;
    }

    public String getSoftwareID() {
        String value = null;
        if (this.isSetAttribute("softwareID")) {
            value = this.getAttribute("softwareID");
        }
        return value;
    }

    public void setBuildID(String buildID) {
        if (buildID != null) {
            Element buildInfo;
            if (!this.isSetElement("BuildInformation")) {
                buildInfo = this.session.createCommonElement("BuildInformation");
                this.setContent(buildInfo);
            }
            buildInfo = this.getChild("BuildInformation");
            buildInfo.setAttribute("buildID", buildID);
            this.setContent(buildInfo);
        } else {
            this.unSetElement("BuildInformation");
        }
    }

    public MaintenanceInformation getMaintenanceInformation() {
        MaintenanceInformationImpl information = null;
        if (this.isSetElement("MaintenanceInformation")) {
            Element element = this.getChild("MaintenanceInformation");
            information = new MaintenanceInformationImpl(element, this.session);
        }
        return information;
    }

    public void setManufacturerInformation(ManufacturerInformation information) {
        if (information == null) {
            this.unSetElement("Manufacturer");
        } else {
            this.setContent((SPIDataObject)((Object)information));
        }
    }

    public void setVersion(String version) {
        if (version == null) {
            this.unSetElement("Version");
        } else {
            Element versionElement = this.session.createCommonElement("Version");
            versionElement.setTextContent(version);
            this.setContent(versionElement);
        }
    }

    public void setSoftwareID(String softwareID) {
        this.setAttribute("softwareID", softwareID);
    }

    public void setMaintenanceInformation(MaintenanceInformation information) {
        if (information == null) {
            this.unSetElement("MaintenanceInformation");
        } else {
            this.setContent((SPIDataObject)((Object)information));
        }
    }

    public Object clone() {
        return new IdentityImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    public String toString() {
        String description = super.toString();
        description = String.valueOf(description) + "SoftwareID: " + this.getSoftwareID() + "\n";
        description = String.valueOf(description) + "Version: " + this.getVersion() + "\n";
        description = String.valueOf(description) + "BuildID: " + this.getBuildID() + "\n";
        return description;
    }
}

