/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase;

import java.math.BigInteger;
import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * AlternativeRequiredBaseConstraintType provides the type definition for the Alternative elements used in RequiredBase 
 * and LocalizationBase ({@link RequiredBase}) elements. 
 */
public interface AlternativeRequiredBaseConstraint extends DisplayNameable {

	/**
	 * Gets the ID.
	 * 
	 * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
	 * 
	 * @return Constraint identifier scoped to the deployment descriptor.
	 */
	String getID();
	
	/**
	 * Gets the priority.
	 * 
	 * If there are multiple satisfied alternatives during a particular solution deployment, one of the alternatives must be selected. 
	 * The priority attribute communicates the SDD authors prioritization of the alternatives. A lower number represents a higher 
	 * priority with 1 representing the highest priority. Other inputs may also be used to select an alternative. The criteria for 
	 * making this selection are outside of the scope of the SDD.
	 * 
	 * @return The priority that assists in determining alternative selected when multiple alternatives evaluate to true.
	 */
	BigInteger getPriority();
	
	/**
	 * Gets the required base constraints.
	 * 
	 * ResourceConstraints defined here identify one or more particular resources that can serve as the update or localization base. 
	 * If ResourceConstraints are defined for multiple resources, they are all updated or localized by application of the content 
	 * element.
	 * 
	 * @return A collection of requirements on one resource.
	 */
	Collection<RequiredBaseConstraint> getRequiredBaseConstraints();
	
	/**
	 * Sets the ID.
	 * 
	 * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
	 * 
	 * @param id Constraint identifier scoped to the deployment descriptor.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setID(String id);
	
	/**
	 * Sets the priority.
	 * 
	 * If there are multiple satisfied alternatives during a particular solution deployment, one of the alternatives must be selected. 
	 * The priority attribute communicates the SDD authors prioritization of the alternatives. A lower number represents a higher 
	 * priority with 1 representing the highest priority. Other inputs may also be used to select an alternative. The criteria for 
	 * making this selection are outside of the scope of the SDD.
	 * 
	 * @param priority The priority that assists in determining alternative selected when multiple alternatives evaluate to true.
	 * <ul>**default value=1</ul>
	 * 
	 */
	void setPriority(BigInteger priority);
	
	/**
	 * Sets the required base constraints.
	 * 
	 * ResourceConstraints defined here identify one or more particular resources that can serve as the update or localization base. 
	 * If ResourceConstraints are defined for multiple resources, they are all updated or localized by application of the content 
	 * element.
	 * 
	 * @param requiredBaseConstraint A collection of requirements on one resource.
	 */
	void setRequiredBaseConstraints(Collection<RequiredBaseConstraint> requiredBaseConstraint);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
	
}
