/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * The SPKIData element within KeyInfo  is used to convey information related to SPKI public 
 * key pairs, certificates and other SPKI data. SPKISexp is the base64 encoding of a SPKI 
 * canonical S-expression. SPKIData must have at least one SPKISexp; SPKISexp can be 
 * complemented/extended by siblings from an external namespace within SPKIData, or SPKIData 
 * can be entirely replaced with an alternative SPKI XML structure as a child of KeyInfo.
 *
 */
public interface SPKIData {
	/**
	 * Gets the SPKISexp.
	 * 
	 * SPKISexp is the base64 encoding of a SPKI canonical S-expression. 
	 * 
	 * SPKIData must have at least one SPKISexp; SPKISexp can be complemented/extended by 
	 * siblings from an external namespace within SPKIData, or SPKIData 
	 * can be entirely replaced with an alternative SPKI XML structure as a child of KeyInfo.
	 * 
	 * @return The value of SPKISexp.
	 */
	byte[] getSPKISexp();
	
	/**
	 * Sets the SPKISexp.
	 * 
	 * SPKISexp is the base64 encoding of a SPKI canonical S-expression. 
	 * 
	 * SPKIData must have at least one SPKISexp; SPKISexp can be complemented/extended by 
	 * siblings from an external namespace within SPKIData, or SPKIData 
	 * can be entirely replaced with an alternative SPKI XML structure as a child of KeyInfo.
	 * 
	 * @param spkiSexp A new value for SPKISexp.
	 */
	void setSPKISexp(byte[] spkiSexp);
}
