/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.ValidationFactoryImpl;


public interface ValidationFactory {
	
	static ValidationFactory DEFAULT_INSTANCE = ValidationFactoryImpl.getDefaultInstance();
	
	/**
	 * Create an instance of the SDD_DAS.
	 * 
	 * @return A new SDD_DAS instance
	 */
	SDD_DAS createSDD_DAS();
	
	/**
	 * Create an instance of the XML_DAS.
	 * 
	 * @return A new XML_DAS instance
	 */
	XML_DAS createXML_DAS();
	
	/**
	 * Create an instance of the SDDManager.
	 * 
	 * @return A new SDDManager instance
	 */
	SDDManager createSDDManager();
}
