/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;

public class ContentType {
	
	public static PackageContent merge( PackageContent content1, PackageContent content2){
		if( equals(content1,content2)){
			//use the contentRef from content1, update all refs that point to content2 to use content1
			Util.updateContentRefs(content2.getContentID(), content1.getContentID());

			return content1;
		}
		
		return null;
		
	}
	
	public static boolean equals( PackageContent content1, PackageContent content2){
		//pathname and content purpose must be the same
		
		if(content1.getPathname().equals(content2.getPathname())){
			if(content1.getContentPurpose().equals(content2.getContentPurpose())){
				return true;
			}
		}
		return false;
	}

}
