/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg.Messages;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataCollector;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.util.BTGLogUtil;
import org.osgi.framework.BundleContext;

/**
 * 
 */
public class BTGPlugin extends Plugin {
    
    // The shared instance.
    private static final String DATACOLLECTORS_EXTENSION_POINT = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg.dataCollectors"; //$NON-NLS-1$
    private static final String DATAAGGREGATOR_EXTENSION_POINT = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg.dataAggregator"; //$NON-NLS-1$
    private static BTGPlugin plugin;
    private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.tooling.btg");//$NON-NLS-1$
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.tooling.btg.stdout");//$NON-NLS-1$
 
    // ---------------------------Methods generated by the wizard

    
    public BTGPlugin() {
        plugin = this;
        
    }

    /**
     * This method is called upon plug-in activation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    /**
     * Returns the shared instance.
     */
    public static BTGPlugin getDefault() {
        return plugin;
    }

    public static Collection<IBTGDataCollector> getDataCollectorInstances() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataCollectorPoint = registry.getExtensionPoint(DATACOLLECTORS_EXTENSION_POINT);
        IExtension[] dataCollectorExtensions = dataCollectorPoint.getExtensions();
                
        if (dataCollectorExtensions.length == 0) {
        	consoleLogger.info(Messages.getString("BTGPlugin.2")); //$NON-NLS-1$
            return null;
        }
        else {
        	Collection<IBTGDataCollector> pluginInstances = new ArrayList<IBTGDataCollector>();
        	
        	for (int i = 0; i < dataCollectorExtensions.length; i++) {
            	IExtension extension = dataCollectorExtensions[i];
            	IConfigurationElement[] elements = extension.getConfigurationElements();
            	IConfigurationElement configurationElement = elements[0];
            	
            	try {
            		pluginInstances.add((IBTGDataCollector)configurationElement.createExecutableExtension("class")); //$NON-NLS-1$
                }
                catch (CoreException e) {
                	consoleLogger.severe("CoreException");
                    consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                    logger.log(Level.SEVERE, "ExceptionStack", e);
                }
            }
            
            return pluginInstances;
        }
    }
    
    public static Collection<IBTGDataAggregator> getDataAggregatorInstances() {
    	IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataAggregatorPoint = registry.getExtensionPoint(DATAAGGREGATOR_EXTENSION_POINT);
        IExtension[] dataAggregatorExtensions = dataAggregatorPoint.getExtensions();
        
        if (dataAggregatorExtensions.length == 0) {
        	consoleLogger.info(Messages.getString("BTGPlugin.4")); //$NON-NLS-1$
            return null;
        }
        else {
        	Collection<IBTGDataAggregator> pluginInstances = new ArrayList<IBTGDataAggregator>();
        	
        	for (int i = 0; i < dataAggregatorExtensions.length; i++) {
            	IExtension extension = dataAggregatorExtensions[i];
            	IConfigurationElement[] elements = extension.getConfigurationElements();
            	IConfigurationElement configurationElement = elements[0];
            	
            	try {
            		pluginInstances.add((IBTGDataAggregator)configurationElement.createExecutableExtension("class")); //$NON-NLS-1$
                }
                catch (CoreException e) {
                	consoleLogger.severe("CoreException");
                    consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                    logger.log(Level.SEVERE, "ExceptionStack", e);
                }
            }
        	
           return pluginInstances;
        }
    }
    
    /*
     * Find the Plug-in ID of the plug-in containing the given DataCollector instance
     */
    public static String getDataCollectorPluginID(IBTGDataCollector dataCollector) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataCollectorPoint = registry.getExtensionPoint(DATACOLLECTORS_EXTENSION_POINT);
        IExtension[] dataCollectorExtensions = dataCollectorPoint.getExtensions();
        
    	for (int i = 0; i < dataCollectorExtensions.length; i++) {
        	IExtension extension = dataCollectorExtensions[i];
        	IConfigurationElement[] elements = extension.getConfigurationElements();
        	IConfigurationElement configurationElement = elements[0];
        	
        	try {
        		
        		Object dataCollectorInstance = configurationElement.createExecutableExtension("class"); //$NON-NLS-1$
        		if (dataCollector.getClass() == dataCollectorInstance.getClass()) {
        			return (extension.getContributor().getName());
        		}
            
        	} catch (CoreException e) {
        		consoleLogger.severe("CoreException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
            }
        }
    	
    	return null;
    }
    
    /*
     * Find the Plug-in ID of the given DataAggregator instance
     */
    public static String getDataAggregatorPluginID(IBTGDataAggregator dataAggregator) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataAggregatorPoint = registry.getExtensionPoint(DATAAGGREGATOR_EXTENSION_POINT);
        IExtension[] dataAggregatorExtensions = dataAggregatorPoint.getExtensions();
        
    	for (int i = 0; i < dataAggregatorExtensions.length; i++) {
        	IExtension extension = dataAggregatorExtensions[i];
        	IConfigurationElement[] elements = extension.getConfigurationElements();
        	IConfigurationElement configurationElement = elements[0];
        	
        	try {
        		
        		Object dataAggregatorInstance = configurationElement.createExecutableExtension("class"); //$NON-NLS-1$
        		if (dataAggregator.getClass() == dataAggregatorInstance.getClass()) {
        			return (extension.getContributor().getName());
        		}
            
        	} catch (CoreException e) {
        		consoleLogger.severe("CoreException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
            }
        }
    	
    	return null;
    }
}
