/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.exception;

import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;

/**
 * Exception for indicating an error has occurred in a CMDBf operation.
 *
 */
public class CMDBfException extends CosmosException {

	private static final long serialVersionUID = 7533778284759566801L;

	public CMDBfException() {
		super();
	}

	public CMDBfException(String message, Throwable cause) {
		super(message, cause);
	}

	public CMDBfException(String message) {
		super(message);
	}

	public CMDBfException(Throwable cause) {
		super(cause);
	}

}
