/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerException;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.dc.provisional.service.finder.client.CosmosServiceFinderClient;
import org.eclipse.cosmos.dc.test.CmdChangeBrokerEPR;
import org.eclipse.cosmos.dc.test.CmdDMInfo;
import org.eclipse.cosmos.dc.test.CmdDeregisterById;
import org.eclipse.cosmos.dc.test.CmdFindDataManagers;
import org.eclipse.cosmos.dc.test.CmdGetDataManagerById;
import org.eclipse.cosmos.dc.test.CmdGetDataManagers;
import org.eclipse.cosmos.dc.test.CmdGetDataManagersByRecordTypeNamespace;
import org.eclipse.cosmos.dc.test.CmdGetSoapVersion;
import org.eclipse.cosmos.dc.test.CmdGraphQuery;
import org.eclipse.cosmos.dc.test.CmdHelp;
import org.eclipse.cosmos.dc.test.CmdPrintBrokerEPR;
import org.eclipse.cosmos.dc.test.CmdRegister;
import org.eclipse.cosmos.dc.test.CmdRegisterAllDataManagers;
import org.eclipse.cosmos.dc.test.CmdRegisterServiceGroup;
import org.eclipse.cosmos.dc.test.CmdSetCredentials;
import org.eclipse.cosmos.dc.test.CmdSetSoapversion;
import org.eclipse.cosmos.dc.test.CmdSettings;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosmosCLI {
    public static String DEFAULT_BROKER_EPR = "http://localhost:8080/axis2/services/Broker";
    private String _serviceFinderEPR = null;
    private String _brokerEPR = null;
    private String _serviceNamespace = null;
    private String username = null;
    private String password = null;
    private int soapVersion = 12;
    private Vector<CommandEntry> _vc = new Vector();

    public static void main(String[] args) throws Exception {
        String brokerEPR = DEFAULT_BROKER_EPR;
        if (args.length != 0) {
            brokerEPR = args[0];
        }
        CosmosCLI clnt = new CosmosCLI(brokerEPR);
        clnt.getInput();
    }

    public CosmosCLI(String epr) {
        this.InitVC();
        this._brokerEPR = new String(epr);
        this._serviceFinderEPR = this._brokerEPR.replaceAll("axis2/services/Broker", "axis2/services/CosmosServiceFinder");
    }

    public void getInput() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        this.printUsage();
        block6: while (true) {
            try {
                while (true) {
                    System.out.print("COSMOS> ");
                    String line = br.readLine();
                    if (line.trim().equals("")) continue;
                    if (line.equals("Exit")) break block6;
                    try {
                        this.handleCommand(line);
                        continue block6;
                    }
                    catch (AxisFault a) {
                        if (a.getCause() != null) {
                            this.logMessage(a.getCause().toString());
                            continue;
                        }
                        this.logMessage(a.getMessage());
                        continue;
                    }
                    catch (BrokerException b) {
                        this.logMessage(b.getMessage());
                        continue;
                    }
                    catch (Exception e) {
                        this.logMessage(MessageFormat.format(Messages.getString("CMDERROR_ERR"), e.getMessage()));
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                System.exit(1);
                break;
            }
        }
    }

    public void logMessage(String message) {
        System.out.println(message);
    }

    public Vector<CommandEntry> getVC() {
        return this._vc;
    }

    public String getServiceFinder() {
        return this._serviceFinderEPR;
    }

    public String getBrokerEPR() {
        return this._brokerEPR;
    }

    public String getServiceNamespace() {
        return this._serviceNamespace;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getSoapversion() {
        return this.soapVersion;
    }

    public void setSoapversion(int s) {
        this.soapVersion = s;
    }

    public void setUser(String u) {
        this.username = u;
    }

    public void setPasswd(String p) {
        this.password = p;
    }

    public void setServiceFinder(String epr) {
        this._serviceFinderEPR = epr;
    }

    public void setServiceNamespace(String sns) {
        this._serviceNamespace = sns;
    }

    public void setBrokerEPR(String b) {
        this._brokerEPR = b;
    }

    public void printDataManager(DataManager dm) {
        int count = 1;
        this.logMessage(MessageFormat.format(Messages.getString("DM_NAME_INFO"), dm.getName()));
        this.logMessage(MessageFormat.format(Messages.getString("DM_HOST_INFO"), dm.getHost()));
        this.logMessage(MessageFormat.format(Messages.getString("DM_DESCRIPTION_INFO"), dm.getDescription()));
        this.logMessage(MessageFormat.format(Messages.getString("DM_ID_INFO"), dm.getId()));
        this.logMessage(MessageFormat.format(Messages.getString("DM_SOAPNAMESPACE_INFO"), dm.getSoapNamespace()));
        this.logMessage(MessageFormat.format(Messages.getString("DM_RECORDTYPENAMESPACE_INFO"), dm.getRecordTypeNamespace()));
        this.logMessage(MessageFormat.format(Messages.getString("DM_SECURITYNAMESPACE_INFO"), dm.getSecurityNamespace()));
        List serviceList = dm.getServices();
        if (serviceList != null) {
            for (Service service : serviceList) {
                String tmp = new String(count++ + " " + service.getName());
                this.logMessage(MessageFormat.format(Messages.getString("DM_SERVICE_INFO"), tmp));
                this.logMessage(MessageFormat.format(Messages.getString("SERVICE_NAMESPACE_INFO"), service.getNamespace()));
                this.logMessage(MessageFormat.format(Messages.getString("SERVICE_EPR_INFO"), service.getEndpointReference()));
                this.logMessage(MessageFormat.format(Messages.getString("SERVICE_DESCRIPTION_INFO"), service.getDescription()));
                this.logMessage("");
            }
        }
    }

    public Iterator<?> doFindDataManagers() throws Exception {
        CosmosServiceFinderClient client = new CosmosServiceFinderClient(this._serviceFinderEPR);
        OMElement dataManagers = client.getDataManagers();
        Vector<DataManager> v = new Vector<DataManager>();
        Iterator iter = dataManagers.getChildElements();
        while (iter.hasNext()) {
            OMElement groupElem = (OMElement)iter.next();
            Group group = Group.getGroup((OMElement)groupElem);
            DataManager dm = new DataManager(group);
            v.add(dm);
        }
        iter = v.iterator();
        return iter;
    }

    public void printUsage() {
        Iterator<CommandEntry> I = this._vc.iterator();
        CommandEntry c = null;
        this.logMessage(Messages.getString("USAGE1_INFO"));
        this.logMessage(Messages.getString("USAGE2_INFO"));
        while (I.hasNext()) {
            c = I.next();
            if (c.usageString().length() > 0) {
                this.printCmdUsage(c);
                continue;
            }
            this.logMessage(c.getCmd());
        }
        this.logMessage("Exit");
        this.logMessage(Messages.getString("LINES_INFO"));
        this.logMessage(Messages.getString("USAGE3_INFO"));
        this.logMessage(Messages.getString("USAGE4_INFO"));
    }

    private void InitVC() {
        CmdHelp c = new CmdHelp(this);
        CmdSettings s = new CmdSettings(this);
        CmdSetSoapversion sv = new CmdSetSoapversion(this);
        CmdSetCredentials sc = new CmdSetCredentials(this);
        CmdGraphQuery gq = new CmdGraphQuery(this);
        CmdFindDataManagers fdm = new CmdFindDataManagers(this);
        CmdGetDataManagers gdm = new CmdGetDataManagers(this);
        CmdRegisterAllDataManagers rdms = new CmdRegisterAllDataManagers(this);
        CmdRegister rdm = new CmdRegister(this);
        CmdRegisterServiceGroup rsg = new CmdRegisterServiceGroup(this);
        CmdDeregisterById drid = new CmdDeregisterById(this);
        CmdPrintBrokerEPR pbe = new CmdPrintBrokerEPR(this);
        CmdChangeBrokerEPR cbe = new CmdChangeBrokerEPR(this);
        CmdGetDataManagerById dmid = new CmdGetDataManagerById(this);
        CmdGetDataManagersByRecordTypeNamespace dmrec = new CmdGetDataManagersByRecordTypeNamespace(this);
        CmdDMInfo dmi = new CmdDMInfo(this);
        CmdGetSoapVersion gsv = new CmdGetSoapVersion(this);
        this._vc.add(c);
        this._vc.add(s);
        this._vc.add(sv);
        this._vc.add(sc);
        this._vc.add(gq);
        this._vc.add(fdm);
        this._vc.add(gdm);
        this._vc.add(dmid);
        this._vc.add(dmrec);
        this._vc.add(rdms);
        this._vc.add(rdm);
        this._vc.add(rsg);
        this._vc.add(drid);
        this._vc.add(pbe);
        this._vc.add(cbe);
        this._vc.add(dmi);
        this._vc.add(gsv);
    }

    private void handleCommand(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        Tokenizer nst = new Tokenizer(st);
        Iterator<CommandEntry> I = this._vc.iterator();
        CommandEntry c = null;
        if (nst.hasMoreTokens()) {
            String command = nst.nextToken();
            while (I.hasNext()) {
                c = I.next();
                if (!c.IsMatch(command)) continue;
                if (c.validateArguments(nst, line)) {
                    c.performAction();
                }
                return;
            }
        }
        this.logMessage(Messages.getString("CMD_NOT_FOUND_ERR"));
        this.printUsage();
    }

    private void printCmdUsage(CommandEntry c) {
        String ret = null;
        ret = new String(MessageFormat.format(Messages.getString(c.usageString()), c.getCmd()));
        this.logMessage(ret);
    }
}

