/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IContentSelectorSupport;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IDialect;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IPropertyValueOperators;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IQueryCapabilities;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IQueryServiceMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordConstraintSupport;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordTypeList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRegistrationServiceMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRelationshipTemplateSupport;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IServiceDescription;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IXpathSupport;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.MetadataArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.ITransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceMetadataInputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private String currentElementData;
    private Boolean bQueryMetadata = true;
    private IQueryServiceMetadata queryServiceMetadata = null;
    private IRegistrationServiceMetadata registrationServiceMetadata = null;
    private IQueryCapabilities queryCapabilities = null;
    private IRecordConstraintSupport recordConstraintSupport = null;
    private IXpathSupport xpathSupport = null;
    private IRecordTypeList recordTypeList = null;
    private IRecordTypes recordTypes = null;
    private IMetadataArtifactFactory artifactFactory = null;

    public ServiceMetadataInputStreamHandler(boolean queryMetadata, IMetadataArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
        this.bQueryMetadata = queryMetadata;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/serviceMetadata".equals(uri)) {
            return;
        }
        if (this.bQueryMetadata.booleanValue() && "queryServiceMetadata".equals(localName)) {
            this.queryServiceMetadata = this.artifactFactory.createQueryServiceMetadata();
        } else if (!this.bQueryMetadata.booleanValue() && "registrationServiceMetadata".equals(localName)) {
            this.registrationServiceMetadata = this.artifactFactory.createRegistrationServiceMetadata();
        } else if ("serviceDescription".equals(localName)) {
            IServiceDescription serviceDescription = this.artifactFactory.createServiceDescription();
            if (this.bQueryMetadata.booleanValue()) {
                if (this.queryServiceMetadata != null) {
                    this.queryServiceMetadata.setServiceDescription(serviceDescription);
                }
            } else if (this.registrationServiceMetadata != null) {
                this.registrationServiceMetadata.setServiceDescription(serviceDescription);
            }
        } else if (this.bQueryMetadata.booleanValue() && "queryCapabilities".equals(localName)) {
            this.queryCapabilities = this.artifactFactory.createQueryCapabilities();
            if (this.queryServiceMetadata != null) {
                this.queryServiceMetadata.setQueryCapabilities(this.queryCapabilities);
            }
        } else if (this.bQueryMetadata.booleanValue() && "relationshipTemplateSupport".equals(localName)) {
            String minimumMaximum;
            IRelationshipTemplateSupport relationshipTemplateSupport = this.artifactFactory.createRelationshipTemplateSupport();
            String depthLimit = attributes.getValue("depthLimit");
            if (depthLimit != null) {
                relationshipTemplateSupport.setDepthLimit(Boolean.parseBoolean(depthLimit));
            }
            if ((minimumMaximum = attributes.getValue("minimumMaximum")) != null) {
                relationshipTemplateSupport.setMinimumMaximum(Boolean.parseBoolean(minimumMaximum));
            }
            if (this.queryCapabilities != null) {
                this.queryCapabilities.setRelationshipTemplateSupport(relationshipTemplateSupport);
            }
        } else if (this.bQueryMetadata.booleanValue() && "contentSelectorSupport".equals(localName)) {
            String propertySelector;
            IContentSelectorSupport contentSelectorSupport = this.artifactFactory.createContentSelectorSupport();
            String recordTypeSelector = attributes.getValue("recordTypeSelector");
            if (recordTypeSelector != null) {
                contentSelectorSupport.setRecordTypeSelector(Boolean.parseBoolean(recordTypeSelector));
            }
            if ((propertySelector = attributes.getValue("propertySelector")) != null) {
                contentSelectorSupport.setPropertySelector(Boolean.parseBoolean(propertySelector));
            }
            if (this.queryCapabilities != null) {
                this.queryCapabilities.setContentSelectorSupport(contentSelectorSupport);
            }
        } else if (this.bQueryMetadata.booleanValue() && "recordConstraintSupport".equals(localName)) {
            String propertyValueConstraint;
            this.recordConstraintSupport = this.artifactFactory.createRecordConstraintSupport();
            String recordTypeConstraint = attributes.getValue("recordTypeConstraint");
            if (recordTypeConstraint != null) {
                this.recordConstraintSupport.setRecordTypeConstraint(Boolean.parseBoolean(recordTypeConstraint));
            }
            if ((propertyValueConstraint = attributes.getValue("propertyValueConstraint")) != null) {
                this.recordConstraintSupport.setPropertyValueConstraint(Boolean.parseBoolean(propertyValueConstraint));
            }
            if (this.queryCapabilities != null) {
                this.queryCapabilities.setRecordConstraintSupport(this.recordConstraintSupport);
            }
        } else if (this.bQueryMetadata.booleanValue() && "propertyValueOperators".equals(localName)) {
            String isNull;
            String like;
            String contains;
            String greaterOrEqual;
            String greater;
            String lessOrEqual;
            String less;
            IPropertyValueOperators propertyValueOperators = this.artifactFactory.createPropertyValueOperators();
            String equal = attributes.getValue("equal");
            if (equal != null) {
                propertyValueOperators.setEqual(Boolean.parseBoolean(equal));
            }
            if ((less = attributes.getValue("less")) != null) {
                propertyValueOperators.setLess(Boolean.parseBoolean(less));
            }
            if ((lessOrEqual = attributes.getValue("lessOrEqual")) != null) {
                propertyValueOperators.setLessOrEqual(Boolean.parseBoolean(lessOrEqual));
            }
            if ((greater = attributes.getValue("greater")) != null) {
                propertyValueOperators.setGreater(Boolean.parseBoolean(greater));
            }
            if ((greaterOrEqual = attributes.getValue("greaterOrEqual")) != null) {
                propertyValueOperators.setGreaterOrEqual(Boolean.parseBoolean(greaterOrEqual));
            }
            if ((contains = attributes.getValue("contains")) != null) {
                propertyValueOperators.setContains(Boolean.parseBoolean(contains));
            }
            if ((like = attributes.getValue("like")) != null) {
                propertyValueOperators.setLike(Boolean.parseBoolean(like));
            }
            if ((isNull = attributes.getValue("isNull")) != null) {
                propertyValueOperators.setNull(Boolean.parseBoolean(isNull));
            }
            if (this.recordConstraintSupport != null) {
                this.recordConstraintSupport.setPropertyValueOperators(propertyValueOperators);
            }
        } else if (this.bQueryMetadata.booleanValue() && "xpathSupport".equals(localName)) {
            this.xpathSupport = this.artifactFactory.createXpathSupport();
            if (this.queryCapabilities != null) {
                this.queryCapabilities.setXpathSupport(this.xpathSupport);
            }
        } else if ("recordTypeList".equals(localName)) {
            this.recordTypeList = this.artifactFactory.createRecordTypeList();
            if (this.bQueryMetadata.booleanValue()) {
                if (this.queryServiceMetadata != null) {
                    this.queryServiceMetadata.setRecordTypeList(this.recordTypeList);
                }
            } else if (this.registrationServiceMetadata != null) {
                this.registrationServiceMetadata.setRecordTypeList(this.recordTypeList);
            }
        } else if ("recordTypes".equals(localName)) {
            String schemaLocation;
            this.recordTypes = this.artifactFactory.createRecordTypes();
            String namespace = attributes.getValue("namespace");
            if (namespace != null) {
                this.recordTypes.setNamespace(namespace);
            }
            if ((schemaLocation = attributes.getValue("schemaLocation")) != null) {
                this.recordTypes.setSchemaLocation(schemaLocation);
            }
            if (this.recordTypeList != null) {
                this.recordTypeList.addRecordTypes(this.recordTypes);
            }
        } else if ("recordType".equals(localName)) {
            String appliesTo;
            IRecordType recordType = this.artifactFactory.createRecordType();
            String lName = attributes.getValue("localName");
            if (lName != null) {
                recordType.setLocalName(lName);
            }
            if ((appliesTo = attributes.getValue("appliesTo")) != null) {
                recordType.setAppliesTo(appliesTo);
            }
            if (this.recordTypes != null) {
                this.recordTypes.addRecordType(recordType);
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/serviceMetadata".equals(uri)) {
            return;
        }
        if ("mdrId".equals(localName)) {
            if (this.bQueryMetadata.booleanValue()) {
                if (this.queryServiceMetadata != null && this.queryServiceMetadata.getServiceDescription() != null) {
                    this.queryServiceMetadata.getServiceDescription().setMdrId(this.currentElementData);
                }
            } else if (this.registrationServiceMetadata != null && this.registrationServiceMetadata.getServiceDescription() != null) {
                this.registrationServiceMetadata.getServiceDescription().setMdrId(this.currentElementData);
            }
        } else if ("description".equals(localName)) {
            if (this.bQueryMetadata.booleanValue()) {
                if (this.queryServiceMetadata != null && this.queryServiceMetadata.getServiceDescription() != null) {
                    this.queryServiceMetadata.getServiceDescription().setDescription(this.currentElementData);
                }
            } else if (this.registrationServiceMetadata != null && this.registrationServiceMetadata.getServiceDescription() != null) {
                this.registrationServiceMetadata.getServiceDescription().setDescription(this.currentElementData);
            }
        } else if (this.bQueryMetadata.booleanValue() && "dialect".equals(localName)) {
            IDialect dialect = this.artifactFactory.createDialect();
            dialect.setDialect(this.currentElementData);
            if (this.xpathSupport != null) {
                this.xpathSupport.addDialect(dialect);
            }
        }
        this.currentElementData = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        this.currentElementData = this.currentElementData == null ? tempData : String.valueOf(this.currentElementData) + tempData;
    }

    public IRootElement getResult() {
        if (this.bQueryMetadata.booleanValue()) {
            return this.queryServiceMetadata;
        }
        return this.registrationServiceMetadata;
    }

    protected IMetadataArtifactFactory getArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = MetadataArtifactFactory.getInstance();
        }
        return this.artifactFactory;
    }
}

