/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xs.XSComplexTypeDefinition;

public class AcyclicStructure {
    private Map<String, List<AcyclicEntry>> entries = new Hashtable<String, List<AcyclicEntry>>();

    public void add(XSComplexTypeDefinition type, AcyclicEntry acyclicEntry) {
        String typeQName = String.valueOf(type.getNamespace()) + "/" + type.getName();
        List<AcyclicEntry> acyclicEntries = this.entries.get(typeQName);
        if (acyclicEntries == null) {
            acyclicEntries = new ArrayList<AcyclicEntry>();
            this.entries.put(typeQName, acyclicEntries);
        }
        acyclicEntries.add(acyclicEntry);
    }

    public String[] keys() {
        Iterator<String> keySet = this.entries.keySet().iterator();
        String[] keys = new String[this.entries.size()];
        int i = 0;
        while (keySet.hasNext()) {
            keys[i++] = keySet.next();
        }
        return keys;
    }

    public AcyclicEntry[] get(String key) {
        List<AcyclicEntry> list = this.entries.get(key);
        return list == null ? null : list.toArray(new AcyclicEntry[list.size()]);
    }

    public AcyclicEntry[] get(XSComplexTypeDefinition type, String alias) {
        AcyclicEntry[] entries = this.get(String.valueOf(type.getNamespace()) + "/" + type.getName());
        if (entries == null) {
            return new AcyclicEntry[0];
        }
        ArrayList<AcyclicEntry> foundEntries = new ArrayList<AcyclicEntry>();
        int i = 0;
        while (i < entries.length) {
            String[] aliases = entries[i].getAliases();
            int j = 0;
            while (j < aliases.length) {
                if (alias.equals(aliases[j])) {
                    foundEntries.add(entries[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return foundEntries.toArray(new AcyclicEntry[foundEntries.size()]);
    }

    public static class AcyclicEntry {
        private String uri;
        private String localName;
        private String reference;
        private XSComplexTypeDefinition type;
        private String ownerAlias;
        private int lineNumber;
        private String[] aliases;
        private int[] nodePath;
        private int documentPosition;

        public String getURI() {
            return this.uri;
        }

        public void setURI(String uri) {
            this.uri = uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String localName) {
            this.localName = localName;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public XSComplexTypeDefinition getType() {
            return this.type;
        }

        public void setType(XSComplexTypeDefinition type) {
            this.type = type;
        }

        public String getOwnerAlias() {
            return this.ownerAlias;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public void setAliases(String[] aliases) {
            this.aliases = aliases;
            this.ownerAlias = aliases == null || aliases.length <= 0 ? null : aliases[0];
        }

        public int[] getNodePath() {
            return this.nodePath;
        }

        public void setNodePath(int[] nodePath) {
            this.nodePath = nodePath;
        }

        public int getDocumentPosition() {
            return this.documentPosition;
        }

        public void setDocumentPosition(int documentPosition) {
            this.documentPosition = documentPosition;
        }
    }
}

