/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.common.XMLInternalUtility;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementModel
extends ElementLocation {
    private String source;
    private String elementName;
    private int endingLine;
    private int endingColumn;
    private String additionalSchemaLocation;
    private List<String> calculatedValidationSchemas;
    private List<String> aliases;

    public ElementModel(String name, String filePath, int lineNumber, int columnNumber) {
        super(filePath, lineNumber, columnNumber);
        this.elementName = name;
        this.aliases = new ArrayList<String>();
    }

    public ElementModel(Node node, String filePath, int lineNumber, int columnNumber) {
        this(node.getNodeName(), filePath, lineNumber, columnNumber);
        StringBuffer sb = new StringBuffer();
        XMLInternalUtility.serializeNode(sb, node);
        this.setSource(sb.toString());
    }

    public int getEndingLine() {
        return this.endingLine;
    }

    public void setEndingLine(int endingLine) {
        this.endingLine = endingLine;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String contents) {
        this.source = contents;
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getEndingColumn() {
        return this.endingColumn;
    }

    public void setEndingColumn(int columnNumber) {
        this.endingColumn = columnNumber;
    }

    public int numberOfLines() {
        if (this.getLineNumber() > this.getEndingLine()) {
            return 0;
        }
        return this.getEndingLine() - this.getLineNumber() + 1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.elementName + "> line=" + this.getLineNumber() + ", col=" + this.getColumnNumber();
    }

    public void setAdditionalSchemaLocation(String string) {
        this.additionalSchemaLocation = string;
    }

    public String getAdditionalSchemaLocation() {
        return this.additionalSchemaLocation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElementModel)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ElementModel elementModel = (ElementModel)o;
        return this.elementName.equals(elementModel.getElementName()) && this.isEquals(this.aliases, elementModel.aliases) && new Path(this.getFilePath()).equals((Object)new Path(elementModel.getFilePath())) && (this.source == null ? elementModel.getSource() == null : this.source.equals(elementModel.getSource()));
    }

    private boolean isEquals(List<String> aliases1, List<String> aliases2) {
        int size = 0;
        if (aliases1 == null && aliases2 != null || aliases2 == null && aliases1 != null || (size = aliases1.size()) != aliases2.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (!aliases1.contains(aliases2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getAliases() {
        return this.aliases.toArray(new String[this.aliases.size()]);
    }

    public void setAliases(List<String> aliases) {
        this.aliases.addAll(aliases);
    }

    public List<String> getCalculatedValidationSchemas() {
        return this.calculatedValidationSchemas;
    }

    public void setCalculatedValidationSchemas(List<String> calculatedValidationSchemas) {
        this.calculatedValidationSchemas = calculatedValidationSchemas;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }
}

