/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.Schematron;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBindings {
    private static final String UNTARGETED = "untargeted";
    protected Map<String, Map<String, List<Schematron>>> data = new HashMap<String, Map<String, List<Schematron>>>();
    private List<Schematron> globallyBoundRules = new ArrayList<Schematron>();

    public void bindRule(String alias, Schematron schematronRule) {
        this.bindRule(UNTARGETED, alias, schematronRule);
    }

    public void bindRule(String uri, String localName, Schematron schematronRule) {
        List<Schematron> rules;
        Map<String, List<Schematron>> schematronRuleMappings = null;
        schematronRuleMappings = this.data.get(uri);
        if (schematronRuleMappings == null) {
            schematronRuleMappings = new HashMap<String, List<Schematron>>();
            this.data.put(uri, schematronRuleMappings);
        }
        if ((rules = schematronRuleMappings.get(localName)) == null) {
            rules = new ArrayList<Schematron>();
            schematronRuleMappings.put(localName, rules);
        }
        rules.add(schematronRule);
    }

    public void addGloballyBoundRule(Schematron schematronRule) {
        this.globallyBoundRules.add(schematronRule);
    }

    public List<Schematron> getBoundRules(String alias) {
        return this.getBoundRules(UNTARGETED, alias);
    }

    public List<Schematron> getBoundRules(String uri, String localName) {
        String[] stringArray;
        Map<String, List<Schematron>> schematronRules = this.data.get(uri);
        if (schematronRules == null) {
            return null;
        }
        String transformedAlias = null;
        if (UNTARGETED.equals(uri)) {
            try {
                URIReference uriReference = new URIReference(null, localName);
                uriReference.transform();
                transformedAlias = uriReference.getDocumentReference();
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        if (transformedAlias == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = localName;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = localName;
            stringArray = stringArray3;
            stringArray3[1] = transformedAlias;
        }
        return this.retrieveRules(schematronRules, stringArray);
    }

    private List<Schematron> retrieveRules(Map<String, List<Schematron>> schematronRules, String[] keys) {
        for (String mapKey : schematronRules.keySet()) {
            int i = 0;
            while (i < keys.length) {
                if (keys[i].startsWith(mapKey)) {
                    return schematronRules.get(mapKey);
                }
                ++i;
            }
        }
        return null;
    }

    public List<Schematron> getGloballyBoundRules() {
        return this.globallyBoundRules;
    }

    public boolean isRuleBindingPresent() {
        return this.data.size() > 0;
    }
}

