/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.TextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOutput
extends TextOutput {
    private File file;
    private BufferedWriter bufferedWriter;

    @Override
    public void initialize(Map<String, Object> attributes) {
        super.initialize(attributes);
        String filePath = (String)attributes.get("attribute.file.output");
        try {
            if (filePath != null) {
                this.file = new File(filePath);
                FileOutputStream fileOutput = new FileOutputStream(filePath);
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutput));
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        this.file = null;
    }

    public String getFilePath() {
        if (this.file == null) {
            return SMLValidationMessages.outputSystem;
        }
        return this.file.getAbsolutePath();
    }

    @Override
    protected void writeMessage(String message) {
        try {
            if (this.bufferedWriter == null) {
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            }
            this.bufferedWriter.write(String.valueOf(message) + IValidationConstants.LINE_SEPARATOR);
            this.bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.file = null;
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        }
    }

    @Override
    public void close() {
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
            }
        }
        catch (IOException iOException) {}
    }
}

