/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.internal.validation.artifacts.SchemaBindings;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBindingsBuilder
extends AbstractDataBuilder<SchemaBindings> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.SchemaBindingDataBuilder";
    private SchemaBindings schemaBindings = new SchemaBindings();
    private SchemaBindings.SchemaBinding schemaBinding;
    private boolean documentAliasElement;
    private StringBuffer documentAliasBuffer;
    private boolean endOfHeader;

    @Override
    public void initialize(Map<String, Object> init) {
        super.initialize(init);
        this.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.endOfHeader) {
            return;
        }
        super.startElement(uri, localName, qname, attributes);
        if (!this.isSMLIFElement()) {
            return;
        }
        if ("schemaBindings".equals(localName)) {
            this.schemaBindings.setPresent(true);
        } else if ("schemaBinding".equals(localName) || "defaultSchema".equals(localName) || "noSchemaBinding".equals(localName)) {
            this.schemaBinding = new SchemaBindings.SchemaBinding();
        } else if ("namespaceBinding".equals(localName)) {
            String aliases = attributes.getValue("", "aliases");
            aliases = this.isNull(aliases) ? attributes.getValue("http://www.w3.org/2008/09/sml-if", "aliases") : aliases;
            String string = aliases = this.isNull(aliases) ? attributes.getValue("aliases") : aliases;
            if (this.isNull(aliases)) {
                return;
            }
            StringTokenizer st = new StringTokenizer(aliases);
            while (st.hasMoreTokens()) {
                this.schemaBinding.addSchemaAlias(st.nextToken());
            }
        } else if ("documentAlias".equals(localName)) {
            this.documentAliasElement = true;
            this.documentAliasBuffer = new StringBuffer();
        } else if ("definitions".equals(localName) || "instances".equals(localName)) {
            this.endOfHeader = true;
        }
    }

    private boolean isNull(String str) {
        return str == null || str.length() <= 0;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.documentAliasElement) {
            this.documentAliasBuffer.append(new String(ch, start, length).trim());
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.endOfHeader) {
            return;
        }
        super.endElement(uri, localName, name);
        if (!this.isSMLIFElement() || this.schemaBinding == null) {
            return;
        }
        if ("defaultSchema".equals(localName)) {
            this.schemaBindings.setDefaultBinding(this.schemaBinding);
        } else if ("documentAlias".equals(localName)) {
            this.documentAliasElement = false;
            this.schemaBinding.addDocumentAlias(this.documentAliasBuffer.toString());
        } else if ("schemaBinding".equals(localName)) {
            this.schemaBindings.addBinding(this.schemaBinding);
            this.schemaBinding = null;
        } else if ("noSchemaBinding".equals(localName)) {
            this.schemaBindings.setNoSchemaBindings(this.schemaBinding);
            this.schemaBinding = null;
        }
    }

    @Override
    public SchemaBindings getDataStructure() {
        return this.schemaBindings;
    }
}

