/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementNode;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLValidatingBuilder
extends AbstractDataBuilder<Map<String, ElementNode>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.SMLValidatingBuilder";
    Map<String, ElementNode> typeElements = new HashMap<String, ElementNode>();
    private PSVIProvider psviProvider;

    public SMLValidatingBuilder(PSVIProvider psviProvider) {
        super.addEvent(1);
        this.psviProvider = psviProvider;
    }

    @Override
    public Map<String, ElementNode> getDataStructure() {
        return this.typeElements;
    }

    @Override
    public void error(SAXParseException parseException) throws SAXException {
        throw parseException;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.psviProvider == null) {
            return;
        }
        ElementPSVI elementDeclaration = this.psviProvider.getElementPSVI();
        XSTypeDefinition typeDefinition = elementDeclaration.getTypeDefinition();
        if (typeDefinition.getTypeCategory() != 15) {
            return;
        }
        XSObjectList annotationList = ((XSComplexTypeDefinition)typeDefinition).getAnnotations();
        if (annotationList == null || annotationList.getLength() <= 0) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document domDocument = null;
        try {
            domDocument = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        int i = 0;
        int annotationCount = annotationList.getLength();
        while (i < annotationCount) {
            XSObject annotation = annotationList.item(i);
            ((XSAnnotation)annotation).writeAnnotation((Object)domDocument, (short)3);
            Node acyclicAttribute = domDocument.getFirstChild().getAttributes().getNamedItemNS("http://www.w3.org/2008/09/sml", "acyclic");
            if (acyclicAttribute != null) {
                System.out.println(acyclicAttribute.getNodeValue());
            }
            ++i;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }
}

