/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.provisional.repository.exception;

/**
 * This exception is thrown when there are no available instances 
 * of a repository to instantiate.
 * 
 * 
 * @author Ali Mehregani
 */
public class MissingRepositoryException extends Exception
{
	/**
	 * Serial version UID
	 */
	private static final long serialVersionUID = -6599046892897275812L;

	public MissingRepositoryException(String message, Throwable cause)
	{
		super(message, cause);
	}	
	
	public MissingRepositoryException(String message)
	{
		super(message);
	}
}
