/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a record type identified by id with property children
 * 
 * 
 * @author David Whiteman
 */
public interface ISelectedRecordType extends IXMLWritable {

	/**
	 * Add a property to the set of properties being requested as part of the query
	 * 
	 * @param property
	 */
	public void addSelectedProperty(IPropertyId propertyId);

	/**
	 * Answer an array of properties that are being requested to be returned in the query result
	 * @return
	 */
	public IPropertyId[] getSelectedProperties();

	/**
	 * Answer the local name for the record type
	 * 
	 * @return
	 */
	public String getLocalName();

	/**
	 * Answer the URI for the record type's namespace
	 * 
	 * @return
	 */
	public URI getNamespace();

	/**
	 * Set the local name for the record type
	 * 
	 * @param locName
	 */
	public void setLocalName(String locName);

	/**
	 * Set the namespace for the record type
	 * 
	 * @param createURI
	 */
	public void setNamespace(URI namespace);

}
