/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import org.eclipse.cosmos.rm.internal.validation.reference.ReferenceContext;

public class ReferenceDescriptor
{
	private int lineNumber;
	private String filePath;
	private String reference;
	private ReferenceContext context;

	
	public ReferenceDescriptor(String filePath, int lineNumber, String reference)
	{
		this.filePath = filePath;
		this.lineNumber = lineNumber;
		this.reference = reference;
	}
	
	/**
	 * @return the lineNumber
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}
	/**
	 * @return the filePath
	 */
	public String getFilePath()
	{
		return filePath;
	}
	/**
	 * @return the reference
	 */
	public String getReference()
	{
		return reference;
	}


	public void setContext(ReferenceContext refContext) {
		
		context = refContext;
	}

	/**
	 * @return the context
	 */
	public ReferenceContext getContext() {
		return context;
	}
}
