/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompletionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompositeInstallableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompositeUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ConfigurationUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ConstrainedResourceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentSelectionFeatureImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.FeatureImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.GroupImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.InstallableUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageSetImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LocalizationUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.MultiFeatureSelectImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.MultiplicityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.PackageFeatureReferenceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.RelationshipImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ResultingChangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ResultingResourceImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentSelectionFeature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Feature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.NestedFeature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentUnitFactoryImpl
extends SPIObject
implements ContentUnitFactory {
    private SPISessionImpl session;
    private static final String CONFIGURATION_UNIT_TYPE = "sdd-dd:ConfigurationUnitType";
    private static final String INSTALLABLE_UNIT_TYPE = "sdd-dd:InstallableUnitType";
    private static final String LOCALIZATION_UNIT_TYPE = "sdd-dd:LocalizationUnitType";

    public ContentUnitFactoryImpl(SPISessionImpl session) {
        super(session);
        this.session = session;
    }

    @Override
    public Completion createCompletion(String completionType, String resourceReference) {
        this.session.testParameter(completionType, 1, null);
        this.session.testParameter(resourceReference, 2, null);
        Element completionElement = this.session.createDeploymentElement("Completion");
        CompletionImpl c = new CompletionImpl(completionElement, this.session);
        c.setCompletionType(completionType);
        c.setCompletionResourceReference(resourceReference);
        return c;
    }

    @Override
    public ConfigurationUnit createConfigurationUnit(String id, String targetResourceReference, Artifact configArtifact) {
        this.session.testParameter(id, 1, null);
        this.session.testParameter(targetResourceReference, 2, null);
        this.session.testParameter(configArtifact, 3, null);
        Element configElement = this.session.createDeploymentElement("ConfigurationUnit");
        this.session.insertNode((Node)configElement, (Node)this.session.createDeploymentElement("Artifacts"), CONFIGURATION_UNIT_TYPE);
        ConfigurationUnitImpl cu = new ConfigurationUnitImpl(configElement, this.session);
        cu.setContentUnitID(id);
        cu.setTargetResourceReference(targetResourceReference);
        cu.setConfigurationArtifact(configArtifact);
        return cu;
    }

    @Override
    public InstallableUnit createInstallableUnit(String id, String targetResourceReference, Artifact installArtifact) {
        this.session.testParameter(id, 1, null);
        this.session.testParameter(targetResourceReference, 2, null);
        this.session.testParameter(installArtifact, 3, null);
        Element iuElement = this.session.createDeploymentElement("InstallableUnit");
        this.session.insertNode((Node)iuElement, (Node)this.session.createDeploymentElement("Artifacts"), INSTALLABLE_UNIT_TYPE);
        InstallableUnitImpl iu = new InstallableUnitImpl(iuElement, this.session);
        iu.setContentUnitID(id);
        iu.setTargetResourceReference(targetResourceReference);
        iu.setInstallArtifact(installArtifact);
        return iu;
    }

    @Override
    public InstallableUnit createInstallableUnit(String id, String targetResourceReference, Artifact initialArtifact, int artifactType) {
        this.session.testParameter(id, 1, null);
        this.session.testParameter(targetResourceReference, 2, null);
        this.session.testParameter(initialArtifact, 3, null);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] validValues = nArray;
        this.session.testIntParameter(artifactType, 4, validValues);
        Element iuElement = this.session.createDeploymentElement("InstallableUnit");
        this.session.insertNode((Node)iuElement, (Node)this.session.createDeploymentElement("Artifacts"), INSTALLABLE_UNIT_TYPE);
        InstallableUnitImpl iu = new InstallableUnitImpl(iuElement, this.session);
        iu.setContentUnitID(id);
        iu.setTargetResourceReference(targetResourceReference);
        switch (artifactType) {
            case 0: {
                iu.setInstallArtifact(initialArtifact);
                break;
            }
            case 1: {
                iu.setUndoArtifact(initialArtifact);
                break;
            }
            case 2: {
                iu.setUninstallArtifact(initialArtifact);
                break;
            }
            case 3: {
                iu.setUpdateArtifact(initialArtifact);
            }
        }
        return iu;
    }

    @Override
    public LocalizationUnit createLocalizationUnit(String id, String targetResourceReference, Artifact installArtifact) {
        this.session.testParameter(id, 1, null);
        this.session.testParameter(targetResourceReference, 2, null);
        this.session.testParameter(installArtifact, 3, null);
        Element luElement = this.session.createDeploymentElement("LocalizationUnit");
        this.session.insertNode((Node)luElement, (Node)this.session.createDeploymentElement("Artifacts"), LOCALIZATION_UNIT_TYPE);
        LocalizationUnitImpl lu = new LocalizationUnitImpl(luElement, this.session);
        lu.setContentUnitID(id);
        lu.setTargetResourceReference(targetResourceReference);
        lu.setInstallArtifact(installArtifact);
        return lu;
    }

    @Override
    public LocalizationUnit createLocalizationUnit(String id, String targetResourceReference, Artifact initialArtifact, int artifactType) {
        this.session.testParameter(id, 1, null);
        this.session.testParameter(targetResourceReference, 2, null);
        this.session.testParameter(initialArtifact, 3, null);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] validValues = nArray;
        this.session.testIntParameter(artifactType, 4, validValues);
        Element luElement = this.session.createDeploymentElement("LocalizationUnit");
        this.session.insertNode((Node)luElement, (Node)this.session.createDeploymentElement("Artifacts"), LOCALIZATION_UNIT_TYPE);
        LocalizationUnitImpl lu = new LocalizationUnitImpl(luElement, this.session);
        lu.setContentUnitID(id);
        lu.setTargetResourceReference(targetResourceReference);
        switch (artifactType) {
            case 0: {
                lu.setInstallArtifact(initialArtifact);
                break;
            }
            case 1: {
                lu.setUndoArtifact(initialArtifact);
                break;
            }
            case 2: {
                lu.setUninstallArtifact(initialArtifact);
                break;
            }
            case 3: {
                lu.setUpdateArtifact(initialArtifact);
            }
        }
        return lu;
    }

    @Override
    public Language createLanguage(String type) {
        this.session.testParameter(type, 1, null);
        Element languageElement = this.session.createDeploymentElement("Language");
        LanguageImpl l = new LanguageImpl(languageElement, this.session);
        l.setType(type);
        return l;
    }

    @Override
    public ResultingChange createResultingChange() {
        Element resultingChangeElement = this.session.createDeploymentElement("ResultingChange");
        return new ResultingChangeImpl(resultingChangeElement, this.session);
    }

    @Override
    public ResultingResource createResultingResource(String resultingResourceReference) {
        this.session.testParameter(resultingResourceReference, 1, null);
        Element resultingResElement = this.session.createDeploymentElement("ResultingResource");
        ResultingResourceImpl rr = new ResultingResourceImpl(resultingResElement, this.session);
        rr.setResourceReference(resultingResourceReference);
        return rr;
    }

    @Override
    public Relationship createRelationship(String relatedResourceRef, String type) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createRelationship");
        this.session.testParameter(relatedResourceRef, 1, null);
        this.session.testParameter(type, 2, null);
        Element relationshipElement = this.session.createDeploymentElement("Relationship");
        RelationshipImpl r = new RelationshipImpl(relationshipElement, this.session);
        r.setRelatedResourceReference(relatedResourceRef);
        r.setType(type);
        this.log.exiting(this.getClass().getName(), "createRelationship");
        return r;
    }

    @Override
    public CompositeInstallable createCompositeInstallable(String id, String operation) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createCompositeInstallable");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(operation, 2, null);
        Element element = this.session.createDeploymentElement("CompositeInstallable");
        CompositeInstallableImpl ci = new CompositeInstallableImpl(element, this.session);
        ci.setContentUnitID(id);
        ci.setOperation(operation);
        this.log.exiting(this.getClass().getName(), "createCompositeInstallable");
        return ci;
    }

    @Override
    public CompositeLocalizationUnit createCompositeLocalizationUnitWithLocalizationUnits(String id, Collection<LocalizationUnit> localizationUnits) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createCompositeLocalizationUnitWithLocalizationUnits");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(localizationUnits, 2, null);
        Element element = this.session.createDeploymentElement("CompositeLocalizationUnit");
        CompositeLocalizationUnitImpl cl = new CompositeLocalizationUnitImpl(element, this.session);
        cl.setContentUnitID(id);
        cl.setLocalizationUnits(localizationUnits);
        this.log.exiting(this.getClass().getName(), "createCompositeLocalizationUnitWithLocalizationUnits");
        return cl;
    }

    @Override
    public CompositeLocalizationUnit createCompositeLocalizationUnitWithCompositeLocalizationUnits(String id, Collection<CompositeLocalizationUnit> compositeLocalizationUnits) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createCompositeLocalizationUnitWithCompositeLocalizationUnits");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(compositeLocalizationUnits, 2, null);
        Element element = this.session.createDeploymentElement("CompositeLocalizationUnit");
        CompositeLocalizationUnitImpl cl = new CompositeLocalizationUnitImpl(element, this.session);
        cl.setContentUnitID(id);
        cl.setCompositeLocalizationUnits(compositeLocalizationUnits);
        this.log.exiting(this.getClass().getName(), "createCompositeLocalizationUnitWithCompositeLocalizationUnits");
        return cl;
    }

    @Override
    public CompositeLocalizationUnit createCompositeLocalizationUnitWithContainedLocalizationPackages(String id, Collection<ReferencedPackage> containedLocalizationPackages) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createCompositeLocalizationUnitWithContainedLocalizationPackages");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(containedLocalizationPackages, 2, null);
        Element element = this.session.createDeploymentElement("CompositeLocalizationUnit");
        CompositeLocalizationUnitImpl cl = new CompositeLocalizationUnitImpl(element, this.session);
        cl.setContentUnitID(id);
        cl.setContainedLocalizationPackages(containedLocalizationPackages);
        this.log.exiting(this.getClass().getName(), "createCompositeLocalizationUnitWithContainedLocalizationPackages");
        return cl;
    }

    @Override
    public CompositeUnit createCompositeUnit(String id) throws InvalidInputException {
        this.session.testParameter(id, 1, null);
        Element element = this.session.createDeploymentElement("CompositeUnit");
        CompositeUnitImpl cu = new CompositeUnitImpl(element, this.session);
        cu.setContentUnitID(id);
        return cu;
    }

    @Override
    public Group createGroup(String id, Collection<String> selectedFeatures) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createGroup");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(selectedFeatures, 2, null);
        Element element = this.session.createDeploymentElement("Group");
        GroupImpl group = new GroupImpl(element, this.session);
        group.setGroupID(id);
        group.setSelectedFeatures(selectedFeatures);
        this.log.exiting(this.getClass().getName(), "createGroup");
        return group;
    }

    @Override
    public LanguageSet createLanguageSet(Collection<Language> languages) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createLanguageSet");
        this.session.testParameter(languages, 1, null);
        Element element = this.session.createDeploymentElement("LanguageSet");
        LanguageSetImpl languageSet = new LanguageSetImpl(element, this.session);
        languageSet.setLanguages(languages);
        this.log.exiting(this.getClass().getName(), "createLanguageSet");
        return languageSet;
    }

    @Override
    public MultiFeatureSelect createMultiFeatureSelect(Collection<String> features) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createMultiFeatureSelect");
        this.session.testParameter(features, 1, null);
        Element element = this.session.createDeploymentElement("MultiSelect");
        MultiFeatureSelectImpl mfs = new MultiFeatureSelectImpl(element, this.session);
        mfs.setFeatures(features);
        this.log.exiting(this.getClass().getName(), "createMultiFeatureSelect");
        return mfs;
    }

    @Override
    public Multiplicity createMultiplicity(Boolean multiplesAllowed) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createMultiplicity");
        this.session.testParameter(multiplesAllowed, 1, null);
        Element element = this.session.createDeploymentElement("Multiplicity");
        MultiplicityImpl mfs = new MultiplicityImpl(element, this.session);
        mfs.setMultiplesAllowed(multiplesAllowed);
        this.log.exiting(this.getClass().getName(), "createMultiplicity");
        return mfs;
    }

    @Override
    public Feature createFeatureWithRequiredFeatures(String id, Collection<String> features) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createFeatureWithRequiredFeatures");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(features, 2, null);
        Element element = this.session.createDeploymentElement("Feature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setRequiredFeature(features);
        this.log.exiting(this.getClass().getName(), "createFeatureWithRequiredFeatures");
        return feature;
    }

    @Override
    public Feature createFeatureWithContentElements(String id, Collection<String> contentReferences) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createFeatureWithContentElements");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(contentReferences, 2, null);
        Element element = this.session.createDeploymentElement("Feature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setContentElements(contentReferences);
        this.log.exiting(this.getClass().getName(), "createFeatureWithContentElements");
        return feature;
    }

    @Override
    public Feature createFeatureWithNestedFeatures(String id, Collection<NestedFeature> features) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createFeatureWithNestedFeatures");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(features, 1, null);
        Element element = this.session.createDeploymentElement("Feature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setNestedFeatures(features);
        this.log.exiting(this.getClass().getName(), "createFeatureWithNestedFeatures");
        return feature;
    }

    @Override
    public Feature createFeatureWithDerivedVariables(String id, Collection<DerivedVariable> derivedVariables) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createFeatureWithDerivedVariables");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(derivedVariables, 1, null);
        Element element = this.session.createDeploymentElement("Feature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setVariables(derivedVariables);
        this.log.exiting(this.getClass().getName(), "createFeatureWithDerivedVariables");
        return feature;
    }

    @Override
    public Feature createFeatureWithPackageFeatureReferences(String id, Collection<PackageFeatureReference> packageFeatureReferences) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createFeatureWithPackageFeatureReferences");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(packageFeatureReferences, 1, null);
        Element element = this.session.createDeploymentElement("Feature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setPackageFeatureReferences(packageFeatureReferences);
        this.log.exiting(this.getClass().getName(), "createFeatureWithPackageFeatureReferences");
        return feature;
    }

    @Override
    public NestedFeature createNestedFeatureWithNestedFeatures(String id, Collection<NestedFeature> features) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createNestedFeatureWithNestedFeatures");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(features, 1, null);
        Element element = this.session.createDeploymentElement("NestedFeature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setNestedFeatures(features);
        this.log.exiting(this.getClass().getName(), "createNestedFeatureWithNestedFeatures");
        return feature;
    }

    @Override
    public NestedFeature createNestedFeatureWithContentElements(String id, Collection<String> contentReferences) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createNestedFeatureWithContentElements");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(contentReferences, 2, null);
        Element element = this.session.createDeploymentElement("NestedFeature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setContentElements(contentReferences);
        this.log.exiting(this.getClass().getName(), "createNestedFeatureWithContentElements");
        return feature;
    }

    @Override
    public NestedFeature createNestedFeatureWithRequiredFeatures(String id, Collection<String> features) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createNestedFeatureWithRequiredFeatures");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(features, 2, null);
        Element element = this.session.createDeploymentElement("NestedFeature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setRequiredFeature(features);
        this.log.exiting(this.getClass().getName(), "createNestedFeatureWithRequiredFeatures");
        return feature;
    }

    @Override
    public NestedFeature createNestedFeatureWithDerivedVariables(String id, Collection<DerivedVariable> derivedVariables) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createNestedFeatureWithDerivedVariables");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(derivedVariables, 1, null);
        Element element = this.session.createDeploymentElement("NestedFeature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setVariables(derivedVariables);
        this.log.exiting(this.getClass().getName(), "createNestedFeatureWithDerivedVariables");
        return feature;
    }

    @Override
    public NestedFeature createNestedFeatureWithPackageFeatureReferences(String id, Collection<PackageFeatureReference> packageFeatureReferences) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createNestedFeatureWithPackageFeatureReferences");
        this.session.testParameter(id, 1, null);
        this.session.testParameter(packageFeatureReferences, 1, null);
        Element element = this.session.createDeploymentElement("NestedFeature");
        FeatureImpl feature = new FeatureImpl(element, this.session);
        feature.setFeatureID(id);
        feature.setPackageFeatureReferences(packageFeatureReferences);
        this.log.exiting(this.getClass().getName(), "createNestedFeatureWithPackageFeatureReferences");
        return feature;
    }

    @Override
    public PackageFeatureReference createPackageFeatureReference(String contentElementRef, String packageFeatureRef) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createPackageFeatureReference");
        this.session.testParameter(contentElementRef, 1, null);
        this.session.testParameter(packageFeatureRef, 2, null);
        Element element = this.session.createDeploymentElement("PackageFeatureReference");
        PackageFeatureReferenceImpl pfr = new PackageFeatureReferenceImpl(element, this.session);
        pfr.setContentElementRef(contentElementRef);
        pfr.setPackageFeatureRef(packageFeatureRef);
        this.log.exiting(this.getClass().getName(), "createPackageFeatureReference");
        return pfr;
    }

    @Override
    public ConstrainedResource createConstrainedResource(String resourceRef) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createConstrainedResource");
        this.session.testParameter(resourceRef, 1, null);
        Element element = this.session.createDeploymentElement("ConstrainedResource");
        ConstrainedResourceImpl cr = new ConstrainedResourceImpl(element, this.session);
        cr.setResourceRef(resourceRef);
        this.log.exiting(this.getClass().getName(), "createConstrainedResource");
        return cr;
    }

    @Override
    public ContentSelectionFeature createContentSelectionFeature(String feature) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "createContentSelectionFeature");
        this.session.testParameter(feature, 1, null);
        Element element = this.session.createDeploymentElement("Feature");
        ContentSelectionFeatureImpl csf = new ContentSelectionFeatureImpl(element, this.session);
        csf.setFeature(feature);
        this.log.exiting(this.getClass().getName(), "createContentSelectionFeature");
        return csf;
    }
}

