/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
extends DescribableObject
implements Resource {
    private static final String RESOURCE_TYPE = "sdd-dd:ResourceType";
    private static final String PROPERTY_TYPE = "sdd-dd:PropertyType";
    private static String indent = new String("    ");

    public ResourceImpl(Element rdo, SPISessionImpl session) {
        super(rdo, session, RESOURCE_TYPE);
    }

    @Override
    public String getName() {
        if (this.isSetElement("Name")) {
            Element name = this.getChild("Name");
            return name.getTextContent();
        }
        return null;
    }

    @Override
    public String getResourceID() {
        return this.getAttribute("id");
    }

    @Override
    public String getResourceType() {
        return this.getAttribute("type");
    }

    @Override
    public Properties getProperties() {
        Collection<Element> propertyElements = this.getChildren("Property");
        return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
    }

    @Override
    public Collection<Resource> getHostedResources() {
        Collection<Element> hostedResourceElements = this.getChildren("HostedResource");
        ArrayList<Resource> hostedResources = new ArrayList<Resource>();
        for (Element element : hostedResourceElements) {
            ResourceImpl resource = new ResourceImpl(element, this.session);
            hostedResources.add(resource);
        }
        return hostedResources;
    }

    @Override
    public void setHostedResources(Collection<Resource> newHostedResources) {
        if (newHostedResources != null) {
            this.removeContent(this.getChildren("HostedResource", false));
            this.addContent(newHostedResources);
        } else {
            this.unSetElement("HostedResource");
        }
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.unSetElement("Name");
        } else {
            Element nameElement = this.session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            this.setContent(nameElement);
        }
    }

    @Override
    public void setResourceID(String resourceID) {
        this.session.testParameter(resourceID, 1, null);
        this.setAttribute("id", resourceID);
    }

    @Override
    public void setResourceType(String resourceType) {
        this.session.testParameter(resourceType, 1, null);
        this.setAttribute("type", resourceType);
    }

    @Override
    public void setProperties(Properties props) {
        if (props != null) {
            ArrayList<Element> properties = new ArrayList<Element>();
            this.removeContent(this.getChildren("Property", false));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                Element propertyElement = this.session.createDeploymentElement("Property");
                Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
                Element valueElement = this.session.createDeploymentElement("Value");
                propertyNameElement.setTextContent(key);
                valueElement.setTextContent(value);
                this.session.insertNode((Node)propertyElement, (Node)propertyNameElement, PROPERTY_TYPE);
                this.session.insertNode((Node)propertyElement, (Node)valueElement, PROPERTY_TYPE);
                properties.add(propertyElement);
            }
            this.addContent(properties);
        } else {
            this.unSetElement("Property");
        }
    }

    @Override
    public Object clone() {
        return new ResourceImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    String toString(String offset) {
        String resourceContents = new String(String.valueOf(offset) + "Hosted Resource - ID: " + this.getResourceID() + " , Type: " + this.getResourceType() + "\n");
        Properties resourceProperties = this.getProperties();
        for (Object key : resourceProperties.keySet()) {
            resourceContents = String.valueOf(resourceContents) + offset + " Resource Property - Key = \"" + key + "\" , value = \"" + resourceProperties.getProperty((String)key) + "\"\n";
        }
        Collection<Resource> hostedResources = this.getHostedResources();
        for (Resource hostedResource : hostedResources) {
            resourceContents = String.valueOf(resourceContents) + ((ResourceImpl)hostedResource).toString(String.valueOf(indent) + offset);
        }
        return resourceContents;
    }

    @Override
    public String toString() {
        String resourceContents = new String("Resource - ID: " + this.getResourceID() + " , Type: " + this.getResourceType() + "\n");
        Properties resourceProperties = this.getProperties();
        for (Object key : resourceProperties.keySet()) {
            resourceContents = String.valueOf(resourceContents) + " Resource Property - Key = \"" + key + "\" , value = \"" + resourceProperties.getProperty((String)key) + "\"\n";
        }
        Collection<Resource> hostedResources = this.getHostedResources();
        for (Resource hostedResource : hostedResources) {
            resourceContents = String.valueOf(resourceContents) + ((ResourceImpl)hostedResource).toString(indent);
        }
        return resourceContents;
    }
}

