/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageSetImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.MultiplicityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.PackageFeatureReferenceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.DerivedVariableImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.NestedFeature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedFeatureImpl
extends DisplayNameableObject
implements NestedFeature {
    private static final String NESTED_FEATURE_TYPE = "sdd-dd:NestedFeatureType";
    private static final String LANGUAGE_SELECTIONS_TYPE = "sdd-dd:LanguageSelectionsType";
    private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";
    private static final String OPTIONAL_LANGUAGES_TYPE = "sdd-dd:OptionalLanguagesType";

    public NestedFeatureImpl(Element data, SPISessionImpl session) {
        super(data, session, NESTED_FEATURE_TYPE);
    }

    public NestedFeatureImpl(Element data, SPISessionImpl session, String sddSchemaType) {
        super(data, session, sddSchemaType);
    }

    @Override
    public Collection<Language> getMandatoryLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        Element manditoryElement = this.session.getChild(this.getChild("Languages"), "Mandatory");
        if (this.isSetElement("Languages") && manditoryElement != null) {
            Collection<Element> languageElementList = this.session.getChildren(manditoryElement, "Language");
            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, this.session));
            }
        }
        return languages;
    }

    @Override
    public Collection<Language> getOptionalLanguages() {
        Element optionalElement;
        ArrayList<Language> languages = new ArrayList<Language>();
        if (this.isSetElement("Languages") && (optionalElement = this.session.getChild(this.getChild("Languages"), "Optional")) != null) {
            Collection<Element> languageElementList = this.session.getChildren(optionalElement, "Language");
            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, this.session));
            }
        }
        return languages;
    }

    @Override
    public Collection<LanguageSet> getOptionalLanguageSets() {
        ArrayList<LanguageSet> languages = new ArrayList<LanguageSet>();
        Element optionalElement = this.session.getChild(this.getChild("Languages"), "Optional");
        if (this.isSetElement("Languages") && optionalElement != null) {
            Collection<Element> languageElementList = this.session.getChildren(optionalElement, "LanguageSet");
            for (Element element : languageElementList) {
                languages.add(new LanguageSetImpl(element, this.session));
            }
        }
        return languages;
    }

    @Override
    public Condition getCondition() {
        ConditionImpl condition = null;
        if (this.isSetElement("Condition")) {
            condition = new ConditionImpl(this.getChild("Condition"), this.session);
        }
        return condition;
    }

    @Override
    public Collection<String> getContentElements() {
        ArrayList<String> contentElementRefs = new ArrayList<String>();
        Collection<Element> contentElements = this.getChildren("ContentElement");
        for (Element contentElement : contentElements) {
            String contentElementRef = contentElement.getAttribute("contentElementRef");
            if (contentElementRef == null) continue;
            contentElementRefs.add(contentElementRef);
        }
        return contentElementRefs;
    }

    @Override
    public Multiplicity getMultiplicity() {
        MultiplicityImpl multiplicity = null;
        if (this.isSetElement("Multiplicity")) {
            multiplicity = new MultiplicityImpl(this.getChild("Multiplicity"), this.session);
        }
        return multiplicity;
    }

    @Override
    public String getFeatureID() {
        return this.getAttribute("id");
    }

    @Override
    public Collection<NestedFeature> getNestedFeatures() {
        ArrayList<NestedFeature> nestedFeatures = new ArrayList<NestedFeature>();
        Collection<Element> nestedFeatureElements = this.getChildren("NestedFeature");
        for (Element nestedFeatureElement : nestedFeatureElements) {
            nestedFeatures.add(new NestedFeatureImpl(nestedFeatureElement, this.session));
        }
        return nestedFeatures;
    }

    @Override
    public Collection<String> getRequiredFeature() {
        ArrayList<String> requiredFeatureRefs = new ArrayList<String>();
        Collection<Element> requiredFeatureElements = this.getChildren("RequiredFeature");
        for (Element requiredFeatureElement : requiredFeatureElements) {
            String contentElementRef = requiredFeatureElement.getAttribute("featureRef");
            if (contentElementRef == null) continue;
            requiredFeatureRefs.add(contentElementRef);
        }
        return requiredFeatureRefs;
    }

    @Override
    public Collection<DerivedVariable> getVariables() {
        ArrayList<DerivedVariable> derivedVariables = new ArrayList<DerivedVariable>();
        Collection<Element> derivedVariableElements = this.getChildren("Variable");
        for (Element derivedVariableElement : derivedVariableElements) {
            derivedVariables.add(new DerivedVariableImpl(derivedVariableElement, this.session));
        }
        return derivedVariables;
    }

    @Override
    public void setMandatoryLanguages(Collection<Language> languages) {
        Element languageSelectionsElement = this.isSetElement("Languages") ? this.getChild("Languages") : this.session.createDeploymentElement("Languages");
        if (languages != null && !languages.isEmpty()) {
            Element mandatoryElement = this.session.getChild(languageSelectionsElement, "Mandatory");
            if (mandatoryElement == null) {
                mandatoryElement = this.session.createDeploymentElement("Mandatory");
            }
            Collection<Element> languageNodeList = this.session.getChildren(mandatoryElement, "Language");
            for (Element element : languageNodeList) {
                mandatoryElement.removeChild(element);
            }
            for (Language language : languages) {
                this.session.insertNode((Node)mandatoryElement, (SPIDataObject)((Object)language), LANGUAGES_TYPE);
            }
            Collection<Element> manditoryNodeList = this.session.getChildren(languageSelectionsElement, "Manditory");
            for (Element element : manditoryNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            this.session.insertNode((Node)languageSelectionsElement, (Node)mandatoryElement, LANGUAGE_SELECTIONS_TYPE);
            this.setContent(languageSelectionsElement);
        } else {
            Collection<Element> manditoryNodeList = this.session.getChildren(languageSelectionsElement, "Manditory");
            for (Element element : manditoryNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            if (this.session.getChildren(languageSelectionsElement, "Manditory").isEmpty() && this.session.getChildren(languageSelectionsElement, "Optional").isEmpty()) {
                this.unSetElement("Languages");
            }
        }
    }

    @Override
    public void setOptionalLanguages(Collection<Language> languages) {
        Element languageSelectionsElement = this.isSetElement("Languages") ? this.getChild("Languages") : this.session.createDeploymentElement("Languages");
        if (languages != null && !languages.isEmpty()) {
            Element optionalElement = this.session.getChild(languageSelectionsElement, "Optional");
            if (optionalElement == null) {
                optionalElement = this.session.createDeploymentElement("Optional");
            }
            Collection<Element> languageNodeList = this.session.getChildren(optionalElement, "Language");
            for (Element element : languageNodeList) {
                optionalElement.removeChild(element);
            }
            for (Language language : languages) {
                this.session.insertNode((Node)optionalElement, (SPIDataObject)((Object)language), OPTIONAL_LANGUAGES_TYPE);
            }
            Collection<Element> optionalNodeList = this.session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            this.session.insertNode((Node)languageSelectionsElement, (Node)optionalElement, LANGUAGE_SELECTIONS_TYPE);
            this.setContent(languageSelectionsElement);
        } else {
            Collection<Element> optionalNodeList = this.session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            if (this.session.getChildren(languageSelectionsElement, "Manditory").isEmpty() && this.session.getChildren(languageSelectionsElement, "Optional").isEmpty()) {
                this.unSetElement("Languages");
            }
        }
    }

    @Override
    public void setOptionalLanguageSets(Collection<LanguageSet> languageSets) {
        Element languageSelectionsElement = this.isSetElement("Languages") ? this.getChild("Languages") : this.session.createDeploymentElement("Languages");
        if (languageSets != null && !languageSets.isEmpty()) {
            Element optionalElement = this.session.getChild(languageSelectionsElement, "Optional");
            if (optionalElement == null) {
                optionalElement = this.session.createDeploymentElement("Optional");
            }
            Collection<Element> languageSetNodeList = this.session.getChildren(optionalElement, "LanguageSet");
            for (Element element : languageSetNodeList) {
                optionalElement.removeChild(element);
            }
            for (LanguageSet languageSet : languageSets) {
                this.session.insertNode((Node)optionalElement, (SPIDataObject)((Object)languageSet), OPTIONAL_LANGUAGES_TYPE);
            }
            Collection<Element> optionalNodeList = this.session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            this.session.insertNode((Node)languageSelectionsElement, (Node)optionalElement, LANGUAGE_SELECTIONS_TYPE);
            this.setContent(languageSelectionsElement);
        } else {
            Collection<Element> optionalNodeList = this.session.getChildren(languageSelectionsElement, "Optional");
            for (Element element : optionalNodeList) {
                languageSelectionsElement.removeChild(element);
            }
            if (this.session.getChildren(languageSelectionsElement, "Manditory").isEmpty() && this.session.getChildren(languageSelectionsElement, "Optional").isEmpty()) {
                this.unSetElement("Languages");
            }
        }
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }

    @Override
    public void setContentElements(Collection<String> content) {
        if (content == null) {
            this.unSetElement("ContentElement");
        } else {
            ArrayList<Element> contentElements = new ArrayList<Element>();
            this.removeContent(this.getChildren("ContentElement", false));
            for (String contentString : content) {
                Element contentElement = this.session.createDeploymentElement("ContentElement");
                contentElement.setAttribute("contentElementRef", contentString);
                contentElements.add(contentElement);
            }
            this.addContent(contentElements);
        }
    }

    @Override
    public void setMultiplicity(Multiplicity multiplicity) {
        if (multiplicity == null) {
            this.unSetElement("Multiplicity");
        } else {
            this.setContent((SPIDataObject)((Object)multiplicity));
        }
    }

    @Override
    public void setFeatureID(String id) {
        this.session.testParameter(id, 1, null);
        this.setAttribute("id", id);
    }

    @Override
    public void setNestedFeatures(Collection<NestedFeature> features) {
        if (features == null) {
            this.unSetElement("NestedFeature");
        } else {
            this.removeContent(this.getChildren("NestedFeature", false));
            this.addContent(features);
        }
    }

    @Override
    public void setRequiredFeature(Collection<String> features) {
        if (features == null) {
            this.unSetElement("RequiredFeature");
        } else {
            ArrayList<Element> requiredFeatureElements = new ArrayList<Element>();
            this.removeContent(this.getChildren("RequiredFeature", false));
            for (String feature : features) {
                Element requiredFeatureElement = this.session.createDeploymentElement("RequiredFeature");
                requiredFeatureElement.setAttribute("featureRef", feature);
                requiredFeatureElements.add(requiredFeatureElement);
            }
            this.addContent(requiredFeatureElements);
        }
    }

    @Override
    public Object clone() {
        return new NestedFeatureImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public Collection<PackageFeatureReference> getPackageFeatureReferences() {
        ArrayList<PackageFeatureReference> pkgFeatureRefs = new ArrayList<PackageFeatureReference>();
        Collection<Element> pkgFeatureRefElements = this.getChildren("PackageFeatureReference");
        for (Element pkgFeatureRefElement : pkgFeatureRefElements) {
            PackageFeatureReferenceImpl pkgFeatureRef = new PackageFeatureReferenceImpl(pkgFeatureRefElement, this.session);
            pkgFeatureRefs.add(pkgFeatureRef);
        }
        return pkgFeatureRefs;
    }

    @Override
    public void setPackageFeatureReferences(Collection<PackageFeatureReference> packageFeatureReferences) {
        if (packageFeatureReferences == null) {
            this.unSetElement("PackageFeatureReference");
        } else {
            this.removeContent(this.getChildren("PackageFeatureReference", false));
            this.addContent(packageFeatureReferences);
        }
    }

    @Override
    public void setVariables(Collection<DerivedVariable> variables) {
        if (variables == null) {
            this.unSetElement("Variable");
        } else {
            this.removeContent(this.getChildren("Variable", false));
            this.addContent(variables);
        }
    }

    @Override
    public Boolean getAddOn() {
        Boolean addOn = null;
        if (this.isSetAttribute("addOn")) {
            addOn = Boolean.parseBoolean(this.getAttribute("addOn"));
        }
        return addOn;
    }

    @Override
    public void setAddOn(Boolean addOn) {
        if (addOn == null) {
            this.unSetAttribute("addOn");
        } else {
            this.setAttribute("addOn", addOn.toString());
        }
    }
}

