/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.validation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.SchemaValidationRule;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.XML_DASImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XMLValidationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDD_DASImpl
extends XML_DASImpl
implements SDD_DAS {
    private static final File commonSchema = ValidatorUtils.getTempFileFromSchemaName("sdd-common-1.0.xsd");
    private static final File ddSchema = ValidatorUtils.getTempFileFromSchemaName("sdd-deploymentDescriptor-1.0.xsd");
    private static final File pdSchema = ValidatorUtils.getTempFileFromSchemaName("sdd-packageDescriptor-1.0.xsd");
    private static final File xmldsigSchema = ValidatorUtils.getTempFileFromSchemaName("xmldsig-core-schema.xsd");
    private static final Collection<File> sddSchemaFiles = Arrays.asList(commonSchema, xmldsigSchema, pdSchema, ddSchema);
    private static final String DD_ROOT_ELEMENT = "DeploymentDescriptor";
    private static final String PD_ROOT_ELEMENT = "PackageDescriptor";

    public SDD_DASImpl() {
        SchemaValidationRule validationRule = null;
        try {
            validationRule = new SchemaValidationRule(sddSchemaFiles);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        if (validationRule != null) {
            this.addValidation(validationRule);
        }
    }

    @Override
    public Collection<XMLValidationError> validate(Document document) throws IllegalArgumentException {
        Element rootElement = document.getDocumentElement();
        if (ValidatorUtils.nodeNameEquals(rootElement, DD_ROOT_ELEMENT) || ValidatorUtils.nodeNameEquals(rootElement, PD_ROOT_ELEMENT)) {
            return super.validate(document);
        }
        throw new IllegalArgumentException();
    }
}

