/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import java.math.BigInteger;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.StringSubstitution;
import org.w3c.dom.Element;

public class StringSubstitutionImpl extends SPIDataObject implements StringSubstitution {
	private static final String SUBSTITUTION_TYPE = "sdd-dd:SubstitutionType";
        
	public StringSubstitutionImpl(Element strSub, SPISessionImpl session) {
        super(strSub, session, SUBSTITUTION_TYPE);
    }
    
    public BigInteger getLimit() {
    	return isSetAttribute("limit") ? new BigInteger(getAttribute("limit")) : null;
    }

    public String getPattern() {
    	return isSetElement("Pattern") ? getChild("Pattern").getTextContent() :  null;
    }

    public Boolean getRequired() {
    	return isSetAttribute("required") ? Boolean.valueOf(getAttribute("required")) : null;
    }

    public String getValue() {
    	return isSetElement("Value") ? getChild("Value").getTextContent() :  null;
    }

    public void setLimit(BigInteger limit) {
        if (limit == null) {
            unSetAttribute("limit");
        }
        else {
        	setAttribute("limit", limit.toString());
        }
    }

    public void setPattern(String pattern) {
        session.testParameter(pattern, 1, null);
        
        Element patterElement = session.createDeploymentElement("Pattern");
        patterElement.setTextContent(pattern);
        setContent(patterElement);
    }

    public void setRequired(Boolean required) {
        if (required == null) {
        	unSetAttribute("required");
        }
        else {
            setAttribute("required", required.toString());
        }        
    }

    public void setValue(String value) {
    	session.testParameter(value, 1, null);
        
        Element vauleElement = session.createDeploymentElement("Value");
        vauleElement.setTextContent(value);
        setContent(vauleElement);
    }

    public Object clone() {
    	Element copy = (Element) getElement().cloneNode(true);
    	StringSubstitutionImpl duplicate = new StringSubstitutionImpl(copy, session);
		
		return duplicate;
    }
}