/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.w3c.dom.Document;

public class Aggregator implements IBTGDataAggregator {
    Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");//$NON-NLS-1$
    Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");//$NON-NLS-1$
    static private DeploymentDescriptor dd1;
	static private DeploymentDescriptor dd2;
	
	static private PackageDescriptor pd1;
	static private PackageDescriptor pd2;
    
    
	public Collection<BTGProperty> getSupportedProperties() {
		List properties = new ArrayList();
		
				
		return properties;
	}

	
	public Collection<Document> aggregateSDDData(
			Collection<SDDFragment> fragments, Properties properties,
			boolean allowIncompleteSDDs) {
		
		try
		{
		//Create a DOM Document from a file
		/*
		DocumentBuilder docBuilder;
		Document doc = null;
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		docBuilderFactory.setIgnoringElementContentWhitespace(true);
		docBuilder = docBuilderFactory.newDocumentBuilder();
		File sourceFile = new File("sdd1.xml");
		doc = docBuilder.parse(sourceFile);

		//Create the SPI objects from the Document 
		SPISession session = SPISession.DEFAULT_INSTANCE;
		dd1 = new DeploymentDescriptorImpl(doc, (SPISessionImpl) session);
		
		
		sourceFile = new File("sdd2.xml");
		doc = docBuilder.parse(sourceFile);

		//Create the SPI objects from the Document 
		
		dd2 = new DeploymentDescriptorImpl(doc, (SPISessionImpl) session);

		
		DeploymentDescriptor resultingDD = DeploymentDescriptorType.merge(dd1,dd2);
		System.out.println("welcome");
		*/
		consoleLogger.info("welcome to the aggregator");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println(e);
		}
		
		
		return null;
	}
	
	public static DeploymentDescriptor getDd1()
	{
		return dd1;
	}
	
	public static DeploymentDescriptor getDd2()
	{
		return dd2;
	}
	
	public static Collection<DeploymentDescriptor> getAllDeploymentDescriptors()
	{
		Collection<DeploymentDescriptor> deploymentDescriptors = new ArrayList<DeploymentDescriptor>();
		deploymentDescriptors.add(getDd1());
		deploymentDescriptors.add(getDd2());
		
		return deploymentDescriptors;
		
	}
	
	public static PackageDescriptor getPd1()
	{
		return pd1;
	}
	
	public static PackageDescriptor getPd2()
	{
		return pd2;
	}
	
	public static Collection<PackageDescriptor> getAllPackageDescriptors()
	{
		Collection<PackageDescriptor> packageDescriptors = new ArrayList<PackageDescriptor>();
		packageDescriptors.add(getPd1());
		packageDescriptors.add(getPd2());
		
		return packageDescriptors;
		
	}
}




