/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.sdd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SDDReader {
	File sddFile = null;
	
	public SDDReader(String sddFileName) {
		sddFile = new File(sddFileName);		
	}
	
	public Document getSDDData() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
		// Create an InputStream for the SDD File
		InputStream inputStream = new FileInputStream(sddFile);
		
		// Build a Document from the InputStream
		Document xmlDocument = null;
		
		// Create a DocumentBuilder and parse the InputStream into a Document
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		xmlDocument = builder.parse(inputStream);		

		inputStream.close();
		
		removeWhitespaceNodes(xmlDocument.getDocumentElement());
		
		return xmlDocument;
	}
	
	/*
	 * Remove all whitespace-only Text nodes from a Document Element
	 */
	private void removeWhitespaceNodes(Element e) {
		NodeList children = e.getChildNodes();
		
		for (int i = children.getLength() - 1; i >= 0; i--) {
			Node child = children.item(i);
			
			if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
				e.removeChild(child);
			}
			else if (child instanceof Element) {
				removeWhitespaceNodes((Element)child);
			}
		}
	}
}
