/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfMessages;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.AbstractServiceHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.ICMDBfQueryOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IRelationshipConstraintHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryInputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.ITemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IDepthLimit;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IItemReference;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQueryInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRecordConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipEndpoint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.ISelectedRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IXPathExpression;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.TransformerException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMDBfQueryOperation
extends AbstractServiceHandler
implements ICMDBfQueryOperation {
    private IQueryHandlerFactory handlerFactory;
    private IQueryInputArtifactFactory queryInputArtifactFactory;
    private IQueryOutputArtifactFactory queryOutputArtifactFactory;

    public CMDBfQueryOperation(IQueryHandlerFactory handlerFactory, IQueryInputArtifactFactory queryInputArtifactFactory) {
        this.handlerFactory = handlerFactory;
        this.queryInputArtifactFactory = queryInputArtifactFactory;
    }

    @Override
    public IQueryResult execute(InputStream query) throws CMDBfServiceException {
        return this.execute((Object)query);
    }

    @Override
    public IQueryResult execute(Reader query) throws CMDBfServiceException {
        return this.execute((Object)query);
    }

    private IQueryResult execute(Object input) throws CMDBfServiceException {
        try {
            IQuery cmdbfQuery = input instanceof Reader ? QueryInputTransformer.transform((Reader)((Reader)input), (IQueryInputArtifactFactory)this.queryInputArtifactFactory, (Map)this.getRuntimeOptions()) : QueryInputTransformer.transform((InputStream)((InputStream)input), (IQueryInputArtifactFactory)this.queryInputArtifactFactory, (Map)this.getRuntimeOptions());
            IQueryResult queryResult = this.processItemTemplates(cmdbfQuery);
            this.processRelationshipTemplates(cmdbfQuery, queryResult);
            this.processContentSelectors(queryResult, cmdbfQuery);
            return queryResult;
        }
        catch (TransformerException e) {
            throw new CMDBfServiceException(1, 5, e.getMessage());
        }
    }

    private IQueryResult processItemTemplates(IQuery query) throws CMDBfServiceException {
        IQueryResult queryResult = this.getQueryOutputArtifactFactory().createQueryResult();
        if (query.getItemTemplateCount() <= 0) {
            return queryResult;
        }
        IItemTemplate[] itemTemplates = query.getItemTemplates();
        IItemTemplateHandler itemHandler = this.handlerFactory.createItemTemplateHandler();
        if (!itemHandler.isInitialized()) {
            itemHandler.initialize(this.getInit());
        }
        int i = 0;
        while (i < itemTemplates.length) {
            block6: {
                INodes result;
                block7: {
                    block5: {
                        result = itemHandler.execute(itemTemplates[i]);
                        IXPathExpression[] xpathExpression = itemTemplates[i].getXpathExpressions();
                        if (xpathExpression != null && xpathExpression.length != 0) break block5;
                        IInstanceIdConstraint instanceConstraint = itemTemplates[i].getInstanceIdConstraint();
                        if (instanceConstraint != null && (result = this.applyItemConstraints(result, new IConstraint[]{instanceConstraint})).isEmpty()) break block6;
                        IRecordConstraint[] recordConstraints = itemTemplates[i].getRecordConstraints();
                        if (recordConstraints == null) break block7;
                        int j = 0;
                        while (j < recordConstraints.length) {
                            if ((result = this.applyItemConstraints(result, (IConstraint[])recordConstraints[j].getRecordTypes())).isEmpty() || (result = this.applyItemConstraints(result, (IConstraint[])recordConstraints[j].getPropertyValues())).isEmpty()) break;
                            ++j;
                        }
                        if (!result.isEmpty()) break block7;
                        break block6;
                    }
                    result = this.applyItemConstraints(result, (IConstraint[])itemTemplates[i].getXpathExpressions());
                }
                if (!result.isStartingContext() && !result.isEmpty() && result.getType() == 1) {
                    queryResult.addNodes(result);
                }
            }
            ++i;
        }
        return queryResult;
    }

    private void processRelationshipTemplates(IQuery cmdbfQuery, IQueryResult queryResult) throws CMDBfServiceException {
        IRelationshipTemplate[] relationshipTemplates = cmdbfQuery.getRelationshipTemplates();
        IRelationshipTemplateHandler relationshipHanlder = this.handlerFactory.createRelationshipTemplateHandler();
        if (!relationshipHanlder.isInitialized()) {
            relationshipHanlder.initialize(this.getInit());
        }
        Hashtable<String, List<IGraphElement>> items = new Hashtable<String, List<IGraphElement>>();
        int i = 0;
        while (i < relationshipTemplates.length) {
            IEdges edges = this.getQueryOutputArtifactFactory().createEdges(relationshipTemplates[i]);
            INodes sourceNodes = queryResult.getNodes(this.retrieveId((IItemReference)relationshipTemplates[i].getSourceElement(), CMDBfMessages.relationshipSource));
            INodes targetNodes = queryResult.getNodes(this.retrieveId((IItemReference)relationshipTemplates[i].getTargetElement(), CMDBfMessages.relationshipTarget));
            if (sourceNodes != null && targetNodes != null) {
                IGraphElement[] sourceElements = sourceNodes.getElements();
                IGraphElement[] targetElements = targetNodes.getElements();
                List<IGraphElement> revisedSourceList = this.retrieveItems(items, relationshipTemplates[i].getSourceElement());
                List<IGraphElement> revisedTargetList = this.retrieveItems(items, relationshipTemplates[i].getTargetElement());
                int j = 0;
                while (j < sourceElements.length) {
                    IEdges currentEdges = null;
                    boolean foundRelationship = false;
                    int k = 0;
                    while (k < targetElements.length) {
                        IGraphElement[] elements;
                        currentEdges = this.retrieveRelationship(queryResult, relationshipTemplates[i], (IItem)sourceElements[j], (IItem)targetElements[k]);
                        IGraphElement[] iGraphElementArray = elements = currentEdges == null ? null : currentEdges.getElements();
                        if (elements != null && elements.length > 0) {
                            foundRelationship = true;
                            if (!revisedTargetList.contains(targetElements[k])) {
                                revisedTargetList.add(targetElements[k]);
                            }
                            int l = 0;
                            while (l < elements.length) {
                                IRelationship relationship = (IRelationship)elements[l];
                                edges.addRelationship(relationship);
                                ++l;
                            }
                        }
                        ++k;
                    }
                    if (foundRelationship && !revisedSourceList.contains(sourceElements[j])) {
                        revisedSourceList.add(sourceElements[j]);
                    }
                    ++j;
                }
                IGraphElement[] relationships = edges.getElements();
                if (relationships != null && relationships.length > 0) {
                    queryResult.addEdges(edges);
                }
            }
            ++i;
        }
        for (String endpointId : items.keySet()) {
            List itemList = (List)items.get(endpointId);
            if (itemList.isEmpty()) {
                queryResult.removeNodes(queryResult.getNodes(endpointId));
                continue;
            }
            INodes nodes = queryResult.getNodes(endpointId);
            nodes.setElements(itemList.toArray(new IGraphElement[itemList.size()]));
        }
    }

    private List<IGraphElement> retrieveItems(Map<String, List<IGraphElement>> items, IRelationshipEndpoint endpoint) {
        String endpointId = endpoint.getId();
        List<IGraphElement> list = items.get(endpointId);
        if (list == null) {
            list = new ArrayList<IGraphElement>();
            items.put(endpointId, list);
        }
        return list;
    }

    private String retrieveId(IItemReference itemReference, String source) throws CMDBfServiceException {
        if (itemReference == null || itemReference.getRef() == null) {
            throw new CMDBfServiceException(0, 0, NLS.bind((String)CMDBfMessages.faultsQueryUnknownTemplate, (Object)source), CMDBfInternalUtility.appendNode((Node)CMDBfInternalUtility.createElement((String)"http://cmdbf.org/schema/1-0-0/datamodel", (String)"cmdbf:graphId"), (Node)CMDBfInternalUtility.createTextNode((String)itemReference.getId())));
        }
        return itemReference.getId();
    }

    private IEdges retrieveRelationship(IQueryResult context, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException {
        IRelationshipTemplateHandler relationshipTemplateHandler;
        IConstraint[] iConstraintArray;
        IRecordConstraint[] recordConstraint = relationshipTemplate.getRecordConstraints();
        ArrayList<Object[]> constraints = new ArrayList<Object[]>();
        if (relationshipTemplate.getInstanceIdConstraint() == null) {
            iConstraintArray = null;
        } else {
            IConstraint[] iConstraintArray2 = new IConstraint[1];
            iConstraintArray = iConstraintArray2;
            iConstraintArray2[0] = relationshipTemplate.getInstanceIdConstraint();
        }
        constraints.add(iConstraintArray);
        if (recordConstraint != null) {
            int i = 0;
            while (i < recordConstraint.length) {
                constraints.add(recordConstraint[i].getRecordTypes());
                constraints.add(recordConstraint[i].getPropertyValues());
                ++i;
            }
        }
        IXPathExpression[] xpathExpressions = relationshipTemplate.getXpathExpressions();
        constraints.add(xpathExpressions);
        IDepthLimit depthLimit = relationshipTemplate.getDepthLimit();
        if (depthLimit != null) {
            this.retrieveId(depthLimit.getIntermediateItemTemplate(), CMDBfMessages.relationshipIntermediate);
        }
        if (!(relationshipTemplateHandler = this.handlerFactory.createRelationshipTemplateHandler()).isInitialized()) {
            relationshipTemplateHandler.initialize(this.getInit());
        }
        IEdges edges = relationshipTemplateHandler.execute(context, relationshipTemplate, source, target);
        int i = 0;
        int constraintCount = constraints.size();
        while (i < constraintCount) {
            if (constraints.get(i) != null && ((IConstraint[])constraints.get(i)).length > 0) {
                edges = this.applyRelationshipConstraints(edges, (IConstraint[])constraints.get(i));
            }
            ++i;
        }
        return edges;
    }

    private IEdges applyRelationshipConstraints(IEdges parent, IConstraint[] constraints) throws CMDBfServiceException {
        if (constraints == null || constraints.length <= 0) {
            return null;
        }
        IRelationshipConstraintHandler constraintHandler = this.handlerFactory.createRelationshipConstraintHandler(constraints[0]);
        if (!constraintHandler.isInitialized()) {
            constraintHandler.initialize(this.getInit());
        }
        boolean status = true;
        IEdges result = parent;
        int i = 0;
        while (status && i < constraints.length) {
            result = constraintHandler.execute(result, constraints[i]);
            result.setStartingContext(false);
            ++i;
        }
        return result;
    }

    private INodes applyItemConstraints(INodes context, IConstraint[] constraints) throws CMDBfServiceException {
        INodes result = context;
        if (constraints == null || constraints.length <= 0) {
            return result;
        }
        IItemConstraintHandler constraintHandler = this.handlerFactory.createItemConstraintHandler(constraints[0]);
        if (!constraintHandler.isInitialized()) {
            constraintHandler.initialize(this.getInit());
        }
        int i = 0;
        while (i < constraints.length) {
            result = constraintHandler.execute(result, constraints[i]);
            result.setStartingContext(false);
            ++i;
        }
        return result;
    }

    private void processContentSelectors(IQueryResult result, IQuery query) {
        int itemTemplateCount = query.getItemTemplateCount();
        IItemTemplate[] itemTemplates = query.getItemTemplates();
        IRelationshipTemplate[] relationshipTemplates = query.getRelationshipTemplates();
        int i = 0;
        int templateCount = itemTemplateCount + query.getRelationshipTemplateCount();
        while (i < templateCount) {
            boolean isItemTemplate = i < itemTemplateCount;
            this.processContentSelectors(result, (ITemplate)(isItemTemplate ? itemTemplates[i] : relationshipTemplates[i - itemTemplateCount]), isItemTemplate);
            ++i;
        }
    }

    private void processContentSelectors(IQueryResult result, ITemplate template, boolean isItemTemplate) {
        String templateId = template.getId();
        if (template.isSuppressFromResult()) {
            if (isItemTemplate) {
                INodes nodes = result.getNodes(templateId);
                if (nodes != null) {
                    result.removeNodes(nodes);
                }
            } else {
                IEdges edges = result.getEdges(templateId);
                if (edges != null) {
                    result.removeEdges(edges);
                }
            }
            return;
        }
        IContentSelector contentSelector = template.getContentSelector();
        if (contentSelector == null) {
            return;
        }
        INodes elementCollection = isItemTemplate ? result.getNodes(templateId) : result.getEdges(templateId);
        boolean matchedRecords = contentSelector.isMatchedRecords();
        IGraphElement[] graphElements = elementCollection.getElements();
        int j = 0;
        while (j < graphElements.length) {
            this.findMatch(contentSelector, graphElements[j], matchedRecords);
            ++j;
        }
    }

    private void findMatch(IContentSelector contentSelector, IGraphElement graphElement, boolean matchedRecords) {
        IRecord[] records = graphElement.getRecords();
        ISelectedRecordType[] selectedRecordTypes = contentSelector.getSelectedRecordTypes();
        if (selectedRecordTypes == null) {
            return;
        }
        int i = 0;
        while (i < selectedRecordTypes.length) {
            int j = 0;
            while (j < records.length) {
                block6: {
                    StringWriter sw = new StringWriter();
                    records[j].getValue().toXML(sw, 0);
                    Node rootNode = null;
                    try {
                        rootNode = CMDBfInternalUtility.domParseDocument((InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes())).getFirstChild();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block6;
                    }
                    graphElement.removeRecord(records[j]);
                    if (selectedRecordTypes[i].getNamespace().toString().equals(rootNode.getNamespaceURI()) && selectedRecordTypes[i].getLocalName().equals(rootNode.getLocalName())) {
                        this.retrieveProperties(rootNode, selectedRecordTypes[i].getSelectedProperties());
                        IRecord record = this.getQueryOutputArtifactFactory().createRecord(graphElement, null);
                        record.setRecordMetadata(records[j].getRecordMetadata());
                        record.setValue((IXMLWritable)new CMDBfInternalUtility.NodeXMLWritable(rootNode.hasChildNodes() ? rootNode : null));
                        graphElement.addRecord(record);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void retrieveProperties(Node rootNode, IPropertyId[] properties) {
        ArrayList<Node> candidateNodes = new ArrayList<Node>();
        this.findCandidateNodes(rootNode, candidateNodes, properties);
        if (rootNode.hasChildNodes()) {
            NodeList children = rootNode.getChildNodes();
            int i = 0;
            int childCount = children.getLength();
            while (i < childCount) {
                rootNode.removeChild(children.item(0));
                ++i;
            }
        }
        int i = 0;
        int candidateCount = candidateNodes.size();
        while (i < candidateCount) {
            rootNode.appendChild((Node)candidateNodes.get(i));
            ++i;
        }
    }

    private void findCandidateNodes(Node node, List<Node> candidateNodes, IPropertyId[] properties) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                int j = 0;
                while (j < properties.length) {
                    String namespace = properties[j].getNamespace().toString();
                    String localName = properties[j].getLocalName();
                    boolean added = false;
                    if (namespace.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                        candidateNodes.add(child);
                        added = true;
                    } else {
                        NamedNodeMap atts = child.getAttributes();
                        int k = 0;
                        int attCount = atts.getLength();
                        while (k < attCount) {
                            Node currentAtt = atts.item(k);
                            if ((namespace.equals(currentAtt.getNamespaceURI()) || namespace.equals(child.getNamespaceURI())) && localName.equals(currentAtt.getLocalName())) {
                                candidateNodes.add(child);
                                added = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (!added) {
                        this.findCandidateNodes(child, candidateNodes, properties);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected IQueryOutputArtifactFactory getQueryOutputArtifactFactory() {
        if (this.queryOutputArtifactFactory == null) {
            this.queryOutputArtifactFactory = QueryOutputArtifactFactory.getInstance();
        }
        return this.queryOutputArtifactFactory;
    }
}

