/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service;

import java.io.InputStream;
import java.io.Reader;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.ICMDBfService;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.impl.CMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;

/**
 * Represents a CMDBf registration operation.  The {@link #execute(InputStream)} method is
 * used to execute a registration request that conforms to CMDBf. 
 * 
 * 
 * @see CMDBfRegistrationOperation
 * @author Ali Mehregani
 */
public interface ICMDBfRegistrationOperation extends ICMDBfService
{
	/**
	 * Executes the registration request and returns the results using a POJO
	 * representation of a CMDBf registration response
	 * 
	 * @param registration A registration request conforming to CMDBf
	 * @return The registration response
	 * @throws CMDBfServiceException thrown if the request passed in
	 * is invalid
	 */
	public IRegisterResponse execute (InputStream registration) throws CMDBfServiceException;
	
	
	/**
	 * Executes the registration request and returns the results using a POJO
	 * representation of a CMDBf registration response
	 * 
	 * @param registration A registration request conforming to CMDBf
	 * @return The registration response
	 * @throws CMDBfServiceException thrown if the request passed in
	 * is invalid
	 */
	public IRegisterResponse execute (Reader registration) throws CMDBfServiceException;
}
