/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.response.artifacts;

import java.util.List;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.ITemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.AbstractGraphCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;

/**
 * Abstract parent class of Nodes and Edges that introduces the idea of a template
 * 
 * @author David Whiteman
 */
public abstract class GraphElementCollection extends AbstractGraphCollection {

	private ITemplate template;

	public GraphElementCollection(ITemplate template) 
	{
		this(template.getId());
		this.template = template;		 
	}

	public GraphElementCollection(ITemplate template, List<IGraphElement> elements) 
	{
		this(template);
		setElements(elements);
	}

	public GraphElementCollection(String id) {
		super(id);
	}

	public IContentSelector getDirectives() {		
		return template == null ? null : template.getContentSelector();
	}

	protected ITemplate getTemplate() {
		return this.template;
	}

}
