/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;

/**
 * An object of this type is capable of converting itself to an object of type
 * {@link IRelationship}
 * 
 * 
 * @author Ali Mehregani
 */
public interface IRelationshipConvertible {
	/**
	 * Converts this object to a {@link IRelationship}
	 * 
	 * If the implementor of this interface happens to also implement
	 * {@link IRelationship}, then the method should return the receiver (i.e.
	 * <tt>this</tt>).
	 * 
	 * @param parent
	 *            the parent
	 * @return An {@link IRelationship} representing this object
	 */
	public IRelationship toRelationship(IGraphElementCollection parent);
}
