/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.util.Enumeration;
import java.util.ResourceBundle;

import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public interface ILogger {

	public abstract void addAppender(Appender newAppender);

	public abstract void assertLog(boolean assertion, String msg);

	public abstract void callAppenders(LoggingEvent event);

	public abstract void debug(Object message, Throwable t);

	public abstract void debug(Object message);

	public abstract boolean equals(Object arg0);

	public abstract void error(Object message, Throwable t);

	public abstract void error(Object message);

	public abstract void fatal(Object message, Throwable t);

	public abstract void fatal(Object message);

	public abstract boolean getAdditivity();

	public abstract Enumeration getAllAppenders();

	public abstract Appender getAppender(String name);

	public abstract Priority getChainedPriority();

	public abstract Level getEffectiveLevel();

	public abstract LoggerRepository getHierarchy();

	public abstract Level getLevel();

	public abstract LoggerRepository getLoggerRepository();

	public abstract String getName();

	public abstract Category getParent();

	public abstract Level getPriority();

	public abstract ResourceBundle getResourceBundle();

	public abstract int hashCode();

	public abstract void info(Object message, Throwable t);

	public abstract void info(Object message);

	public abstract boolean isAttached(Appender appender);

	public abstract boolean isDebugEnabled();

	public abstract boolean isEnabledFor(Priority level);

	public abstract boolean isInfoEnabled();

	public abstract boolean isTraceEnabled();

	public abstract void l7dlog(Priority priority, String key, Object[] params,
			Throwable t);

	public abstract void l7dlog(Priority priority, String key, Throwable t);

	public abstract void log(Priority priority, Object message, Throwable t);

	public abstract void log(Priority priority, Object message);

	public abstract void log(String callerFQCN, Priority level, Object message,
			Throwable t);

	public abstract void removeAllAppenders();

	public abstract void removeAppender(Appender appender);

	public abstract void removeAppender(String name);

	public abstract void setAdditivity(boolean additive);

	public abstract void setLevel(Level level);

	public abstract void setPriority(Priority priority);

	public abstract void setResourceBundle(ResourceBundle bundle);

	public abstract String toString();

	public abstract void trace(Object message, Throwable t);

	public abstract void trace(Object message);

	public abstract void warn(Object message, Throwable t);

	public abstract void warn(Object message);

}