/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.common.provisional.exceptions;

import java.util.Calendar;
import java.util.Date;

/**
 * Base exception class of the COSMOS project.  
 */
public class CosmosException extends Exception implements SituationConstants {

	private static final long serialVersionUID = -4820397960858219509L;
	
    
	protected String _categoryType = null;
	protected Date _situationTime = Calendar.getInstance().getTime();
	protected short _priority = -1;
	protected short _severity = -1;
	protected Object _originator = null;

	/**
	 * Constructor
	 * 
	 */
	public CosmosException() {
	}

	/**
	 * Constructor
	 * 
	 * @param message Error message
	 */
	public CosmosException(String message) {
		super(message);
	}

	/**
	 * Constructor
	 * 
	 * @param cause The originating exception
	 */
	public CosmosException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructor 
	 * 
	 * @param message Error message
	 * @param cause The originating exception
	 */
	public CosmosException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Gets the situation category type
	 * @return
	 */
	public String getCategoryType() {
		return _categoryType;
	}

	/**
	 * Sets the situation category type.  Use constants from SituationConstants class. 
	 * @param type 
	 */
	public void setCategoryType(String type) {
		_categoryType = type;
	}

	/**
	 * Gets situation time
	 * @return
	 */
	public Date getSituationTime() {
		return _situationTime;
	}

	/**
	 * Sets situation time
	 * @param time
	 */
	public void setSituationTime(Date time) {
		_situationTime = time;
	}

	/**
	 * Gets priority
	 * 
	 * @return
	 */
	public short getPriority() {
		return _priority;
	}

	/**
	 * Sets priority
	 */
	public void setPriority(short priority) {
		this._priority = priority;
	}

	/**
	 * Gets severity
	 * 
	 * @return
	 */
	public short getSeverity() {
		return _severity;
	}

	/**
	 * Sets severity
	 * 
	 * @param severity
	 */
	public void setSeverity(short severity) {
		this._severity = severity;
	}

	/** 
	 * Gets the object that the exception was originated
	 * @return
	 */
	public Object getOriginator() {
		return _originator;
	}

	/**
	 * Sets the object that the exception was originated 
	 * @param originator
	 */
	public void setOriginator(Object originator) {
		this._originator = originator;
	}

}
