/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts;

import org.eclipse.cosmos.dc.internal.cmdbf.services.registration.transform.output.artifacts.RegisterResponse;
import org.eclipse.cosmos.dc.internal.cmdbf.services.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.output.artifacts.DeregisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Create objects representing elements in the <registerResponse> XML structure as specified
 * by the CMDBf registration service
 * 
 * 
 * @author David Whiteman
 */
public class RegisterOutputArtifactFactory implements IRegisterOutputArtifactFactory {

	private static IRegisterOutputArtifactFactory instance;

	public static IRegisterOutputArtifactFactory getInstance() {
		if (instance == null) {
			instance = new RegisterOutputArtifactFactory();
		}

		return instance;
	}

	/**
	 * Replace the default factory being used to create instances of
	 * artifact interfaces
	 * 
	 * @param factory
	 */
	public static void setInstance(IRegisterOutputArtifactFactory factory) {
		instance = factory;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createRegisterResponse()
	 */
	public IResponse createResponse() {
		return new RegisterResponse();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createInstanceResponse()
	 */
	public IInstanceResponse createInstanceResponse() {
		return DeregisterOutputArtifactFactory.getInstance().createInstanceResponse();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createDeclined()
	 */
	public IDeclined createDeclined() {
		return DeregisterOutputArtifactFactory.getInstance().createDeclined();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createAccepted()
	 */
	public IAccepted createAccepted() {
		return DeregisterOutputArtifactFactory.getInstance().createAccepted();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createAlternateInstanceId(java.lang.String, java.lang.String)
	 */
	public IAlternateInstanceId createAlternateInstanceId(String mdrId,	String localId) {
		return DeregisterOutputArtifactFactory.getInstance().createAlternateInstanceId(mdrId, localId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createAlternateInstanceId()
	 */
	public IAlternateInstanceId createAlternateInstanceId() {
		return DeregisterOutputArtifactFactory.getInstance().createAlternateInstanceId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory#createInstanceId(java.lang.String, java.lang.String)
	 */
	public IInstanceId createInstanceId(String mdrId, String localId) {
		return CommonArtifactFactory.getInstance().createInstanceId(mdrId, localId);
	}

	public IInstanceId createInstanceId() {
		return CommonArtifactFactory.getInstance().createInstanceId();
	}

}
