/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;


/**
 * Represents a <contentSelectorSupport> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IContentSelectorSupport extends IXMLWritable
{
	/**
	 * set the recordTypeSelector 
	 * 
	 * @param recordTypeSelector
	 */
	public void setRecordTypeSelector(boolean recordTypeSelector);
		
	/**
	 * Retrieve the recordTypeSelector
	 * 
	 * @return recordTypeSelector
	 */
	public boolean isRecordTypeSelector();

	
	/**
	 * set the propertySelector
	 * 
	 * @param propertySelector
	 */
	public void setPropertySelector(boolean propertySelector);
		
	/**
	 * Retrieve the propertySelector
	 * 
	 * @return Boolean propertySelector
	 */
	public boolean isPropertySelector();

}
