/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service;

import java.io.InputStream;
import java.io.Reader;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.ICMDBfService;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;

/**
 * Represents a CMDBf query operation.  The {@link #execute(InputStream)} method is
 * used to execute a query that conforms to CMDBf. 
 * 
 * 
 * @see CMDBfQueryOperation
 * @author Ali Mehregani
 */
public interface ICMDBfQueryOperation extends ICMDBfService
{
	/**
	 * Executes the query and returns the results using a POJO
	 * representation of a CMDBf query response
	 * 
	 * @param query An input stream that stores the query conforming to CMDBf
	 * @return The query response
	 * @throws CMDBfServiceException Thrown to indicate a query fault while processing
	 * the CMDBf query
	 */
    public IQueryResult execute (InputStream query) throws CMDBfServiceException;
    
    
    /**
	 * Executes the query and returns the results using a POJO
	 * representation of a CMDBf query response
	 * 
	 * @param query A reader representing the query conforming to CMDBf
	 * @return The query response
	 * @throws CMDBfServiceException Thrown to indicate a query fault while processing
	 * the CMDBf query
	 */
    public IQueryResult execute (Reader query) throws CMDBfServiceException;
}
