/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IIDResolver.java,v 1.2 2008/01/04 21:44:29 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.common;

/**
 * This interface provides methods to generate unique ids.  In many cases outputter classes require 
 * unique id generation.
 */
public interface IIDResolver {
	/**
	 * Generates a unique id based on an object value
	 * @param id
	 * @return a unique id
	 */
	public Object getId(Object id);
	/**
	 * Resets id resolver state information
	 */
	public void clear();
}
