/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SessionOutputterContextImpl;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SessionStoreImpl;
import org.eclipse.cosmos.internal.dr.ps.common.Configuration;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IStore;

public class SessionOutputterContextImpl
implements IOutputterContext {
    protected ServletContext context;
    protected IStore store;
    protected Locale locale;
    protected Configuration configuration;
    private static ILogger logger = LoggerWrapper.getLogger(SessionOutputterContextImpl.class);

    public SessionOutputterContextImpl(HttpServletRequest request) {
        this.context = request.getSession().getServletContext();
        this.store = new SessionStoreImpl(request.getSession());
        this.locale = request.getLocale();
        this.configuration = new Configuration();
        try {
            String configPath = this.context.getInitParameter("COSMOSUI_CONFIGURATION_PATH");
            if (configPath == null) {
                configPath = "/config";
            }
            this.configuration.load(this.getRealPath(configPath + "/configuration.properties"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public ServletContext getContext(String arg0) {
        return this.context.getContext(arg0);
    }

    public String getInitParameter(String arg0) {
        return this.configuration.getValue((Object)arg0);
    }

    public Enumeration getInitParameterNames() {
        return new IteratorWrapper(this, this.configuration.keySet().iterator());
    }

    public URL getResource(String arg0) throws MalformedURLException {
        return this.context.getResource(arg0);
    }

    public InputStream getResourceAsStream(String arg0) {
        return this.context.getResourceAsStream(arg0);
    }

    public Set getResourcePaths(String arg0) {
        return this.context.getResourcePaths(arg0);
    }

    public void log(String arg0, Throwable arg1) {
        this.context.log(arg0, arg1);
    }

    public void log(String arg0) {
        this.context.log(arg0);
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public IStore getStore() {
        return this.store;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

