/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.List;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterConstants;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.BrokerNodeDecorator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.INodeDecorator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerOutputter
extends AbstractOutputter
implements IOutputterConstants {
    private static ILogger logger = LoggerWrapper.getLogger(BrokerOutputter.class);

    public void render(PrintWriter output, IParameters input) throws Exception {
        String query = input.getParameter("query");
        String nodeDecoratorStr = input.getParameter("nodeDecorator");
        BrokerNodeDecorator nodeDecorator = null;
        if (nodeDecoratorStr != null) {
            try {
                nodeDecorator = (INodeDecorator)Class.forName(nodeDecoratorStr).newInstance();
            }
            catch (RuntimeException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            nodeDecorator = new BrokerNodeDecorator();
        }
        if ("directMDR".equals(input.getParameter("func"))) {
            this.generateMDRJsonNode(output, (INodeDecorator)nodeDecorator, input.getParameter("name"), input.getParameter("queryservice"));
        } else if (query != null && query.equalsIgnoreCase("mdr")) {
            String uri = this.context.getInitParameter("BROKER_EPR");
            BrokerClient brokerclient = new BrokerClient(uri);
            List dataManagers = brokerclient.getDataManagerByNamespace("http://cmdbf.org/schema/1-0-0/query");
            String exclude = input.getParameter("exclude");
            if (exclude != null && !"null".equals(exclude)) {
                int dataManagerCount = dataManagers.size();
                for (int i = 0; i < dataManagerCount; ++i) {
                    DataManager dataManager = (DataManager)dataManagers.get(i);
                    String epr = dataManager.getServiceEPR("http://www.eclipse.org/cosmos/datamanager");
                    if (!exclude.equals(epr)) continue;
                    dataManagers.remove(i);
                    break;
                }
            }
            this.generateJsonNodeList(output, (INodeDecorator)nodeDecorator, dataManagers, "http://cmdbf.org/schema/1-0-0/query");
        } else if (query != null && query.equalsIgnoreCase("cmdbf")) {
            String uri = this.context.getInitParameter("BROKER_EPR");
            BrokerClient brokerclient = new BrokerClient(uri);
            List dataManagers = brokerclient.getDataManagerByNamespace("http://cmdbf.org/schema/1-0-0/registration");
            this.generateJsonNodeList(output, (INodeDecorator)nodeDecorator, dataManagers, "http://cmdbf.org/schema/1-0-0/registration");
        } else {
            String uri = this.context.getInitParameter("BROKER_EPR");
            BrokerClient brokerclient = new BrokerClient(uri);
            List dataManagers = brokerclient.getDataManagers();
            output.print("{ identifier: \"object\",  label: \"title\",  items:[");
            for (int index = 0; index < dataManagers.size(); ++index) {
                DataManager dm = (DataManager)dataManagers.get(index);
                String dmName = nodeDecorator.getDisplayName((Object)dm);
                String nodeClass = nodeDecorator.getNodeClass((Object)dm);
                if (index > 0) {
                    output.print(",");
                }
                List services = dm.getServices();
                String serviceStr = "";
                String propertiesStr = "";
                for (int x = 0; x < services.size(); ++x) {
                    Service service = (Service)services.get(x);
                    if (x > 0) {
                        serviceStr = serviceStr + ",";
                        propertiesStr = propertiesStr + ",";
                    }
                    serviceStr = serviceStr + "[\"" + service.getNamespace() + "\", \"" + service.getEndpointReference() + "\"]";
                    propertiesStr = propertiesStr + "['" + service.getNamespace() + "', '" + service.getEndpointReference() + "']";
                }
                output.print("{nodeClass:\"" + nodeClass + "\", title:\"" + dmName + "\"," + " object:\"dm" + index + "\"," + " mdrId:\"" + dm.getId() + "\"," + " services:[" + serviceStr + "]");
                output.print(", store:[");
                output.print("['name', '[" + dmName + "]']");
                output.print(",['mdrId', '[" + dm.getId() + "]']");
                output.print(",['description', '[" + dm.getDescription() + "]']");
                output.print(",['soapNamespace', '[" + dm.getSoapNamespace() + "]']");
                output.print(",['recordTypeNamespace', '[" + dm.getRecordTypeNamespace() + "]']");
                output.print(",['securityNamespace', '[" + dm.getSecurityNamespace() + "]']");
                output.print("," + propertiesStr);
                output.print("]}");
            }
            output.print("]}");
        }
    }

    protected void generateJsonNodeList(PrintWriter output, INodeDecorator nodeDecorator, List<DataManager> dataManagers, String namespace) {
        output.print("[");
        for (int index = 0; index < dataManagers.size(); ++index) {
            DataManager dm = dataManagers.get(index);
            String dmName = nodeDecorator.getDisplayName((Object)dm);
            if (index > 0) {
                output.print(",");
            }
            String queryServiceEPR = dm.getServiceEPR(namespace);
            String eprString = queryServiceEPR.replace("\n", "");
            output.print("[ \"" + dmName + "\"," + " '" + eprString + "', " + " '" + nodeDecorator.getNodeClass((Object)dm) + "' ]");
        }
        output.print("]");
    }

    protected void generateMDRJsonNode(PrintWriter output, INodeDecorator nodeDecorator, String dmName, String queryService) {
        output.print("{ identifier: \"object\",  label: \"title\",  items:[");
        if (dmName == null) {
            dmName = nodeDecorator.getDisplayName(null);
        }
        String nodeClass = nodeDecorator.getNodeClass(null);
        String serviceStr = "[\"http://cmdbf.org/schema/1-0-0/query\", \"" + queryService + "\"]";
        String propertiesStr = "['http://cmdbf.org/schema/1-0-0/query', '" + queryService + "']";
        output.print("{nodeClass:\"" + nodeClass + "\", title:\"" + dmName + "\"," + " object:\"dm0\"," + " services:[" + serviceStr + "]");
        output.print(", store:[");
        output.print("['name', '[" + dmName + "]']");
        output.print("," + propertiesStr);
        output.print("]}");
        output.print("]}");
    }
}

