/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.exception.CMDBfException;
import org.eclipse.cosmos.dc.provisional.cmdbf.registration.client.RegistrationServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.JSONArray;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.JSONObject;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.XMLUtil;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.StatusResponseOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegistrationOutputter
extends AbstractOutputter {
    private Element cleanseResponse(Element queryResponse) throws Exception {
        Element cleansedRoot = XMLUtil.createElement((QName)new QName("http://cmdbf.org/schema/1-0-0/datamodel", "queryResult", "cmdbf"));
        Document document = cleansedRoot.getOwnerDocument();
        NodeList children = queryResponse.getChildNodes();
        int counter = 0;
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(counter);
            Node adoptedNode = document.adoptNode(child);
            if (adoptedNode == null) {
                adoptedNode = document.importNode(child, true);
                ++counter;
            }
            cleansedRoot.appendChild(adoptedNode);
        }
        return cleansedRoot;
    }

    protected InputStream toInputStream(Node rootNode) throws CMDBfException {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(rootNode), new StreamResult(sw));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
            return inputStream;
        }
        catch (Exception e) {
            throw new CMDBfException(Messages.getString((String)"RegistrationOutputter.OPENSTREAM_ERR"));
        }
    }

    private boolean selectedLocalId(String[] localIdList, String localId) {
        for (String id : localIdList) {
            if (!id.equalsIgnoreCase(localId)) continue;
            return true;
        }
        return false;
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String cmd = input.getParameter("cmd");
        String cmdbfepr = input.getParameter("cmdbfEPR");
        String queryResp = input.getParameter("queryResp");
        String username = input.getParameter("username");
        String password = input.getParameter("password");
        String soapversion = input.getParameter("soapversion");
        Document document = XMLUtil.createDocument((String)queryResp);
        Element queryRespElem = document.getDocumentElement();
        InputStream inputStream = this.toInputStream((Node)this.cleanseResponse(queryRespElem));
        IQueryResult queryResult = QueryOutputTransformer.transform((InputStream)inputStream);
        if (cmd.equalsIgnoreCase("query")) {
            IEdges[] edges;
            output.print("[ ");
            INodes[] nodes = queryResult.getAllNodes();
            int count = 0;
            for (INodes inode : nodes) {
                IGraphElement[] graphElements;
                for (IGraphElement graphElement : graphElements = inode.getElements()) {
                    IInstanceId[] ids;
                    for (IInstanceId id : ids = graphElement.getInstanceIds()) {
                        if (count > 0) {
                            output.print(", ");
                        }
                        ++count;
                        output.print("[ \"Node\", '" + id.getLocalId() + "' ]");
                    }
                }
            }
            for (IEdges edge : edges = queryResult.getAllEdges()) {
                IGraphElement[] graphElements;
                for (IGraphElement graphElement : graphElements = edge.getElements()) {
                    IInstanceId[] ids;
                    for (IInstanceId id : ids = graphElement.getInstanceIds()) {
                        if (count > 0) {
                            output.print(", ");
                        }
                        ++count;
                        output.print("[ \"Edge\", '" + id.getLocalId() + "' ]");
                    }
                }
            }
            output.print("]");
        } else if (cmd.equalsIgnoreCase("register") || cmd.equalsIgnoreCase("deregister")) {
            IRegisterResponse result;
            JSONObject root;
            IEdges[] edges;
            INodes[] nodes;
            Object ciParm;
            boolean bRegister = cmd.equalsIgnoreCase("register");
            URI mdrId = new URI("");
            ArrayList<String> ciliststr = new ArrayList<String>();
            Integer i = 0;
            while ((ciParm = input.getParameter("localid" + i.toString())) != null) {
                ciliststr.add((String)ciParm);
                ciParm = i;
                Integer i$ = i = Integer.valueOf(i + 1);
            }
            String[] localIdList = ciliststr.toArray(new String[ciliststr.size()]);
            IRegisterRequest registerRequest = RegisterInputArtifactFactory.getInstance().createRegisterRequest();
            IDeregisterRequest deregisterRequest = DeregisterInputArtifactFactory.getInstance().createDeregisterRequest();
            for (INodes inode : nodes = queryResult.getAllNodes()) {
                IGraphElement[] graphElements;
                for (IGraphElement graphElement : graphElements = inode.getElements()) {
                    IInstanceId[] ids;
                    boolean bFound = false;
                    for (IInstanceId id : ids = graphElement.getInstanceIds()) {
                        String localId = CMDBfServicesUtil.toString((URI)id.getLocalId());
                        if (!this.selectedLocalId(localIdList, localId)) continue;
                        mdrId = id.getMdrId();
                        bFound = true;
                    }
                    if (!bFound) continue;
                    if (bRegister) {
                        registerRequest.addItem((IItem)graphElement);
                        continue;
                    }
                    deregisterRequest.addItem((IItem)graphElement);
                }
            }
            for (IEdges edge : edges = queryResult.getAllEdges()) {
                IGraphElement[] graphElements;
                for (IGraphElement graphElement : graphElements = edge.getElements()) {
                    IInstanceId[] ids;
                    boolean bFound = false;
                    for (IInstanceId id : ids = graphElement.getInstanceIds()) {
                        String localId = CMDBfServicesUtil.toString((URI)id.getLocalId());
                        if (!this.selectedLocalId(localIdList, localId)) continue;
                        mdrId = id.getMdrId();
                        bFound = true;
                    }
                    if (!bFound) continue;
                    if (bRegister) {
                        registerRequest.addRelationship((IRelationship)graphElement);
                        continue;
                    }
                    deregisterRequest.addRelationship((IRelationship)graphElement);
                }
            }
            registerRequest.setMdrId(mdrId);
            deregisterRequest.setMdrId(mdrId);
            RegistrationServiceClient client = new RegistrationServiceClient(cmdbfepr);
            if (username != null) {
                client.setUsername(username);
            }
            if (password != null) {
                client.setPassword(password);
            }
            if (soapversion != null) {
                client.setSoapVersion(Integer.parseInt(soapversion));
            }
            if (!(root = StatusResponseOutputter.renderStatusResult(null, (IResponse)(result = bRegister ? client.register(registerRequest) : client.deregister(deregisterRequest)))).containsKey((Object)"items")) {
                root.put((Object)"items", (Object)new JSONArray());
            }
            output.write(root.toString());
        }
    }
}

