/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.registration.client.RegistrationServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryInputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IAccepted;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IDeclined;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterConstants;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.JSONArray;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.JSONObject;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.StatusResponseOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class StatusResponseOutputter
extends AbstractOutputter
implements IOutputterConstants {
    private static final String DEREGISTER = "deregister";
    private static final String CMDBF_EPR = "cmdbfEPR";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SOAPVERSION = "soapversion";
    private static final String ACCEPTED_ITEMS = "ACCEPTED_ITEMS";
    private static final String DECLINED_ITEMS = "DECLINED_ITEMS";
    protected static final String AllQuery = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">        <s:itemTemplate id=\"all-items\">                 </s:itemTemplate>        <s:itemTemplate id=\"items-with-relationship\">                   </s:itemTemplate>        <s:relationshipTemplate id=\"all-relationships\">          <s:sourceTemplate ref=\"items-with-relationship\"/>          <s:targetTemplate ref=\"items-with-relationship\"/>        </s:relationshipTemplate></s:query>";

    public void render(PrintWriter output, IParameters input) throws Exception {
        Configuration configuration = new Configuration(input);
        JSONObject rootObject = new JSONObject();
        rootObject.put((Object)"identifier", (Object)"id");
        rootObject.put((Object)"label", (Object)"label");
        if (Configuration.access$000((Configuration)configuration)) {
            for (int i = 0; i < Configuration.access$100((Configuration)configuration).length; ++i) {
                IQueryResult graphResponse = this.submitQuery(Configuration.access$100((Configuration)configuration)[i], "<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">        <s:itemTemplate id=\"all-items\">                 </s:itemTemplate>        <s:itemTemplate id=\"items-with-relationship\">                   </s:itemTemplate>        <s:relationshipTemplate id=\"all-relationships\">          <s:sourceTemplate ref=\"items-with-relationship\"/>          <s:targetTemplate ref=\"items-with-relationship\"/>        </s:relationshipTemplate></s:query>", configuration);
                this.registerDerigisterCI(graphResponse, rootObject, configuration);
            }
        } else {
            String cmdbfQueryService = input.getParameter("queryEPR");
            for (int x = 0; x < Configuration.access$100((Configuration)configuration).length; ++x) {
                String mdrEPR = Configuration.access$100((Configuration)configuration)[x];
                IQueryResult graphResponse = this.submitQuery(mdrEPR, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">        <s:itemTemplate id=\"all-items\">                 </s:itemTemplate>        <s:itemTemplate id=\"items-with-relationship\">                   </s:itemTemplate>        <s:relationshipTemplate id=\"all-relationships\">          <s:sourceTemplate ref=\"items-with-relationship\"/>          <s:targetTemplate ref=\"items-with-relationship\"/>        </s:relationshipTemplate></s:query>", configuration);
                String mdrId = this.getMdrId(graphResponse);
                String ciQuery = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">   <s:itemTemplate id=\"items\" suppressFromResult=\"false\" >      <s:instanceIdConstraint>         <s:instanceId>         <s:mdrId>%s</s:mdrId>         <s:localId>*</s:localId>        </s:instanceId>      </s:instanceIdConstraint>   </s:itemTemplate>   <s:itemTemplate id=\"itemswithrel\" suppressFromResult=\"false\" >      <s:instanceIdConstraint>         <s:instanceId>         <s:mdrId>%s</s:mdrId>         <s:localId>*</s:localId>         </s:instanceId>      </s:instanceIdConstraint>   </s:itemTemplate>   <s:relationshipTemplate id=\"relationship\">      <s:sourceTemplate ref=\"itemswithrel\"/>      <s:targetTemplate ref=\"itemswithrel\"/>   </s:relationshipTemplate></s:query>", mdrId, mdrId, mdrId);
                IQueryResult cmdbfResponse = this.submitQuery(cmdbfQueryService, ciQuery, configuration);
                this.registerDerigisterCI(cmdbfResponse, rootObject, configuration);
            }
        }
        output.print(rootObject.toString());
    }

    public String getMdrId(IQueryResult queryResult) throws Exception {
        INodes[] nodes;
        URI mdrId = new URI("");
        block0: for (INodes inode : nodes = queryResult.getAllNodes()) {
            IGraphElement[] graphElements;
            for (IGraphElement graphElement : graphElements = inode.getElements()) {
                if (graphElement.getInstanceIds() == null || graphElement.getInstanceIds().length <= 0) continue;
                mdrId = graphElement.getInstanceIds()[0].getMdrId();
                continue block0;
            }
        }
        return mdrId.toString();
    }

    public void registerDerigisterCI(IQueryResult queryResult, JSONObject rootObject, Configuration config) throws Exception {
        IEdges[] edges;
        INodes[] nodes;
        IRegisterRequest registerRequest = RegisterInputArtifactFactory.getInstance().createRegisterRequest();
        IDeregisterRequest deregisterRequest = DeregisterInputArtifactFactory.getInstance().createDeregisterRequest();
        URI mdrId = new URI("");
        for (INodes inode : nodes = queryResult.getAllNodes()) {
            IGraphElement[] graphElements;
            for (IGraphElement graphElement : graphElements = inode.getElements()) {
                if (graphElement.getInstanceIds() != null && graphElement.getInstanceIds().length > 0) {
                    mdrId = graphElement.getInstanceIds()[0].getMdrId();
                }
                if (Configuration.access$000((Configuration)config)) {
                    registerRequest.addItem((IItem)graphElement);
                    continue;
                }
                deregisterRequest.addItem((IItem)graphElement);
            }
        }
        for (IEdges edge : edges = queryResult.getAllEdges()) {
            IGraphElement[] graphElements;
            for (IGraphElement graphElement : graphElements = edge.getElements()) {
                if (graphElement.getInstanceIds() != null && graphElement.getInstanceIds().length > 0) {
                    mdrId = graphElement.getInstanceIds()[0].getMdrId();
                }
                if (Configuration.access$000((Configuration)config)) {
                    registerRequest.addRelationship((IRelationship)graphElement);
                    continue;
                }
                deregisterRequest.addRelationship((IRelationship)graphElement);
            }
        }
        registerRequest.setMdrId(mdrId);
        deregisterRequest.setMdrId(mdrId);
        RegistrationServiceClient client = new RegistrationServiceClient(Configuration.access$200((Configuration)config));
        if (Configuration.access$300((Configuration)config) != null) {
            client.setUsername(Configuration.access$300((Configuration)config));
        }
        if (Configuration.access$400((Configuration)config) != null) {
            client.setPassword(Configuration.access$400((Configuration)config));
        }
        if (Configuration.access$500((Configuration)config) != null) {
            client.setSoapVersion(Integer.parseInt(Configuration.access$500((Configuration)config)));
        }
        IRegisterResponse result = Configuration.access$000((Configuration)config) ? client.register(registerRequest) : client.deregister(deregisterRequest);
        StatusResponseOutputter.renderStatusResult((JSONObject)rootObject, (IResponse)result);
    }

    protected IQueryResult submitQuery(String mdrEPR, String query, Configuration config) throws Exception {
        StringReader queryReader = new StringReader(query);
        QueryServiceClient queryService = new QueryServiceClient(mdrEPR);
        if (Configuration.access$300((Configuration)config) != null) {
            queryService.setUsername(Configuration.access$300((Configuration)config));
        }
        if (Configuration.access$400((Configuration)config) != null) {
            queryService.setPassword(Configuration.access$400((Configuration)config));
        }
        if (Configuration.access$500((Configuration)config) != null) {
            queryService.setSoapVersion(Integer.parseInt(Configuration.access$500((Configuration)config)));
        }
        IQuery iquery = QueryInputTransformer.transform((Reader)queryReader);
        return queryService.graphQuery(iquery);
    }

    public static JSONObject renderStatusResult(JSONObject rootJSONObject, IResponse result) throws Exception {
        if (result == null) {
            throw new Exception(Messages.getString((String)"RegisterError.0"));
        }
        if (rootJSONObject == null) {
            rootJSONObject = new JSONObject();
            rootJSONObject.put((Object)"identifier", (Object)"id");
            rootJSONObject.put((Object)"label", (Object)"label");
        }
        IInstanceResponse[] instanceResponse = result.getInstanceResponses();
        boolean acceptedItemsPresent = true;
        boolean declinedItemsPresent = true;
        JSONArray acceptedItems = StatusResponseOutputter.retrieveArray((JSONObject)rootJSONObject, (String)"ACCEPTED_ITEMS");
        JSONArray declinedItems = StatusResponseOutputter.retrieveArray((JSONObject)rootJSONObject, (String)"DECLINED_ITEMS");
        if (acceptedItems == null) {
            acceptedItemsPresent = false;
            acceptedItems = new JSONArray();
        }
        if (declinedItems == null) {
            declinedItemsPresent = false;
            declinedItems = new JSONArray();
        }
        Hashtable idMap = new Hashtable();
        for (int i = 0; i < instanceResponse.length; ++i) {
            int j;
            JSONObject item = StatusResponseOutputter.createItem(idMap, (IInstanceResponse)instanceResponse[i]);
            if (item == null) continue;
            IDeclined declined = instanceResponse[i].getDeclined();
            IAccepted accepted = instanceResponse[i].getAccepted();
            if (declined != null) {
                String[] reasons = declined.getReasons();
                JSONArray reasonsArray = new JSONArray();
                for (j = 0; j < reasons.length; ++j) {
                    reasonsArray.add((Object)StatusResponseOutputter.createJSONObject((String[][])new String[][]{{"id", "REASON" + j}, {"label", reasons[j]}}));
                }
                StatusResponseOutputter.addItem((JSONArray)declinedItems, (JSONObject)item, (JSONArray)reasonsArray);
                continue;
            }
            if (accepted == null) continue;
            IInstanceId[] alternativeInstanceIds = accepted.getAlternateInstanceIds();
            JSONArray alternativeIdArray = new JSONArray();
            for (j = 0; j < alternativeInstanceIds.length; ++j) {
                String mdrId = CMDBfServicesUtil.toString((URI)alternativeInstanceIds[j].getMdrId());
                String localId = CMDBfServicesUtil.toString((URI)alternativeInstanceIds[j].getLocalId());
                alternativeIdArray.add((Object)StatusResponseOutputter.createJSONObject((String[][])new String[][]{{"id", mdrId + localId}, {"mdrId", mdrId}, {"localId", localId}, {"label", localId}}));
            }
            StatusResponseOutputter.addItem((JSONArray)acceptedItems, (JSONObject)item, (JSONArray)alternativeIdArray);
        }
        JSONArray rootJSONArray = new JSONArray();
        if (!acceptedItemsPresent) {
            StatusResponseOutputter.createItemStore((JSONArray)rootJSONArray, (JSONArray)acceptedItems, (boolean)true);
        }
        if (!declinedItemsPresent) {
            StatusResponseOutputter.createItemStore((JSONArray)rootJSONArray, (JSONArray)declinedItems, (boolean)false);
        }
        if (!acceptedItemsPresent || !declinedItemsPresent) {
            StatusResponseOutputter.addArrayToObject((String)"items", (JSONObject)rootJSONObject, (JSONArray)rootJSONArray);
        }
        return rootJSONObject;
    }

    private static JSONArray retrieveArray(JSONObject root, String id) {
        if (root == null || !root.containsKey((Object)"items")) {
            return null;
        }
        JSONArray itemsArray = (JSONArray)root.get((Object)"items");
        int count = itemsArray.size();
        for (int i = 0; i < count; ++i) {
            JSONObject jsonObject = (JSONObject)itemsArray.get(i);
            if (!id.equals(jsonObject.get((Object)"id"))) continue;
            return (JSONArray)jsonObject.get((Object)"response");
        }
        return null;
    }

    private static void createItemStore(JSONArray rootArray, JSONArray items, boolean accepted) {
        if (items.size() <= 0) {
            return;
        }
        String ID = accepted ? "ACCEPTED_ITEMS" : "DECLINED_ITEMS";
        String label = accepted ? Messages.getString((String)"AcceptedItems") : Messages.getString((String)"DeclinedItems");
        JSONObject itemsObject = StatusResponseOutputter.createJSONObject((String[][])new String[][]{{"type", "response"}, {"id", ID}, {"label", label}});
        itemsObject.put((Object)"response", (Object)items);
        rootArray.add((Object)itemsObject);
    }

    private static void addItem(JSONArray itemsArray, JSONObject item, JSONArray innerArray) {
        StatusResponseOutputter.addArrayToObject((String)"response", (JSONObject)item, (JSONArray)innerArray);
        itemsArray.add((Object)item);
    }

    private static void addArrayToObject(String key, JSONObject jsonObject, JSONArray jsonArray) {
        if (jsonArray.size() > 0) {
            jsonObject.put((Object)key, (Object)jsonArray);
        }
    }

    private static JSONObject createItem(Map<String, Boolean> idMap, IInstanceResponse instanceResponse) {
        IInstanceId instanceId = null;
        if (instanceResponse == null || (instanceId = instanceResponse.getInstanceId()) == null) {
            return null;
        }
        String mdrId = CMDBfServicesUtil.toString((URI)instanceId.getMdrId());
        String localId = CMDBfServicesUtil.toString((URI)instanceId.getLocalId());
        String id = mdrId + localId;
        if (idMap.get(id) != null) {
            int counter = 0;
            while (idMap.get(id + counter) != null) {
                ++counter;
            }
            id = id + counter;
        }
        idMap.put(id, Boolean.TRUE);
        return StatusResponseOutputter.createJSONObject((String[][])new String[][]{{"id", id}, {"mdrId", mdrId}, {"localId", localId}, {"label", CMDBfServicesUtil.toString((URI)instanceId.getLocalId())}});
    }

    private static JSONObject createJSONObject(String[][] pairs) {
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < pairs.length; ++i) {
            jsonObject.put((Object)pairs[i][0], (Object)pairs[i][1]);
        }
        return jsonObject;
    }
}

