/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RPMIndexEntry {
    private int tag;
    private int type;
    private long offset;
    private int count;
    private byte[] byteData;
    private int[] intData;
    private short[] shortData;
    private long[] longData;
    private String stringData;
    private String[] stringArrayData;
    private byte[] binData;
    private static final int type_null = 0;
    private static final int type_char = 1;
    private static final int type_int8 = 2;
    private static final int type_int16 = 3;
    private static final int type_int32 = 4;
    private static final int type_int64 = 5;
    private static final int type_string = 6;
    private static final int type_bin = 7;
    private static final int type_string_array = 8;
    private static final int type_i18nstring = 9;

    public byte[] getByteData() {
        return this.byteData;
    }

    public int[] getIntData() {
        return this.intData;
    }

    public short[] getShortData() {
        return this.shortData;
    }

    public long[] getLongData() {
        return this.longData;
    }

    public String getStringData() {
        return this.stringData;
    }

    public String[] getStringArrayData() {
        return this.stringArrayData;
    }

    public byte[] getBinData() {
        return this.binData;
    }

    public int getTag() {
        return this.tag;
    }

    public int getType() {
        return this.type;
    }

    public RPMIndexEntry(int tag, int type, long offset, int count) {
        this.tag = tag;
        this.type = type;
        this.offset = offset;
        this.count = count;
    }

    private String readString(RandomAccessFile file) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        byte[] r = new byte[1];
        file.read(r);
        while (r[0] != 0) {
            strBuf.append(new String(r));
            file.read(r);
        }
        return new String(strBuf);
    }

    private String convertToHexString(byte[] array) {
        StringBuffer hexBuff = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            hexBuff.append(Integer.toHexString(array[i]));
            ++i;
        }
        return new String(hexBuff);
    }

    public void parseData(RandomAccessFile file) throws IOException {
        file.seek(this.offset);
        if (this.type == 0) {
            return;
        }
        if (this.type == 1 || this.type == 2) {
            this.byteData = new byte[this.count];
            int i = 0;
            while (i < this.count) {
                this.byteData[i] = file.readByte();
                ++i;
            }
            this.stringData = String.valueOf(this.byteData);
        } else if (this.type == 3) {
            this.shortData = new short[this.count];
            int i = 0;
            while (i < this.count) {
                this.shortData[i] = file.readShort();
                ++i;
            }
            this.stringData = String.valueOf(this.shortData);
        } else if (this.type == 4) {
            this.intData = new int[this.count];
            int i = 0;
            while (i < this.count) {
                this.intData[i] = file.readInt();
                ++i;
            }
            this.stringData = String.valueOf(this.intData);
        } else if (this.type == 5) {
            this.longData = new long[this.count];
            int i = 0;
            while (i < this.count) {
                this.longData[i] = file.readLong();
                ++i;
            }
            this.stringData = String.valueOf(this.longData);
        } else if (this.type == 6 || this.type == 9) {
            this.stringData = this.readString(file);
        } else if (this.type == 8) {
            this.stringData = null;
            this.stringArrayData = new String[this.count];
            int i = 0;
            while (i < this.count) {
                this.stringArrayData[i] = this.readString(file);
                ++i;
            }
        } else if (this.type == 7) {
            this.binData = new byte[this.count];
            file.read(this.binData);
            this.stringData = this.convertToHexString(this.binData);
        }
    }
}

