/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm.RPMFile;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.BaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.ArtifactFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;

public class RPMReader {
    private static final String SCHEMA_VERSION = "1.0";
    private RPMFile rpmFile = null;
    private File rpmFileHandle = null;
    private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");
    private BaseFactory baseFactory = SPISession.DEFAULT_INSTANCE.createBaseFactory();
    private ContentUnitFactory contentUnitFactory = SPISession.DEFAULT_INSTANCE.createContentUnitFactory();
    private RequirementFactory requirementFactory = SPISession.DEFAULT_INSTANCE.createRequirementFactory();
    private ConditionFactory conditionFactory = SPISession.DEFAULT_INSTANCE.createConditionFactory();
    private ArtifactFactory artifactFactory = SPISession.DEFAULT_INSTANCE.createArtifactFactory();

    public RPMReader(String rpmFileName) throws MalformedURLException, IOException {
        this.rpmFileHandle = new File(rpmFileName);
        this.rpmFile = new RPMFile(this.rpmFileHandle);
    }

    public PackageDescriptor getPackageDescriptor() {
        PackageIdentity identity = this.baseFactory.createPackageIdentity();
        String descriptionValue = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_DESCRIPTION).getStringData();
        TranslatableString description = new TranslatableString(descriptionValue);
        identity.setDescription(description);
        String shortDescriptionValue = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_SUMMARY).getStringData();
        TranslatableString shortDescription = new TranslatableString(shortDescriptionValue);
        identity.setShortDescription(shortDescription);
        String nameValue = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_NAME).getStringData();
        TranslatableString name = new TranslatableString(nameValue);
        identity.setName(name);
        String version = String.valueOf(this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_VERSION).getStringData()) + "-" + this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_RELEASE).getStringData();
        identity.setVersion(version);
        String buildHost = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_BUILDHOST).getStringData();
        int[] buildTime = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_BUILDTIME).getIntData();
        if (buildHost != null && buildTime != null && buildTime.length > 0) {
            String buildID = String.valueOf(buildHost) + "_" + buildTime[0];
            identity.setBuildID(buildID);
        }
        String manufacturerNameValue = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_VENDOR).getStringData();
        TranslatableString manufacturerName = new TranslatableString(manufacturerNameValue);
        ManufacturerInformation manufacturer = this.baseFactory.createManufacturerInformation(manufacturerName);
        identity.setManufacturerInformation(manufacturer);
        Vector<PackageContent> contents = new Vector<PackageContent>();
        String pathName = this.rpmFileHandle.getName();
        PackageContent content = this.baseFactory.createPackageContent("rpmFile", pathName);
        content.setContentPurpose("content");
        contents.add(content);
        PackageDescriptor pd = this.baseFactory.createPackageDescriptor(SCHEMA_VERSION, this.generateDescriptorID(), new Date(), identity, contents);
        return pd;
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        ArrayList<VersionRange> versionRanges;
        VersionRange versionRange;
        ArrayList<Resource> topology = new ArrayList<Resource>();
        Resource osResource = this.baseFactory.createResource("os", "OperatingSystem");
        osResource.setName("linux");
        Properties archProps = new Properties();
        archProps.put("arch", this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_ARCH).getStringData());
        osResource.setProperties(archProps);
        String[] dependencies = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_REQUIRENAME).getStringArrayData();
        ArrayList<Resource> hostedResources = new ArrayList<Resource>();
        int requirementNumber = 1;
        int i = 0;
        while (i < dependencies.length) {
            if (!this.ignoreRequirement(dependencies[i])) {
                Resource hostedResource = this.baseFactory.createHostedResource(String.valueOf(dependencies[i]) + "_" + requirementNumber++, "RequiredSoftware");
                hostedResource.setName(dependencies[i]);
                hostedResources.add(hostedResource);
                Properties props = osResource.getProperties();
                props.put("rpmRequirenameIndex", String.valueOf(i));
                osResource.setProperties(props);
            }
            ++i;
        }
        osResource.setHostedResources(hostedResources);
        topology.add(osResource);
        Resource rpmResource = this.baseFactory.createResource("rpm_pm", "PackageManager");
        rpmResource.setName("RPM Package Manager");
        topology.add(rpmResource);
        Resource pkgResource = this.baseFactory.createResource(this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_NAME).getStringData(), "InstallableResource");
        pkgResource.setName(this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_NAME).getStringData());
        topology.add(pkgResource);
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        Requirement preReqs = this.requirementFactory.createRequirement("PreReqs");
        ArrayList<String> preReqsOperationList = new ArrayList<String>();
        preReqsOperationList.add("install");
        preReqs.setOperations(preReqsOperationList);
        requirements.add(preReqs);
        int i2 = 1;
        ArrayList<RequirementResourceConstraint> preReqsConstraints = new ArrayList<RequirementResourceConstraint>();
        for (Resource resource : hostedResources) {
            RequirementResourceConstraint constraint = this.requirementFactory.createRequirementResourceConstraint("constraint_" + i2++, resource.getResourceID());
            preReqsConstraints.add(constraint);
            String versionRequirement = this.findVersionRequirement(resource);
            if (versionRequirement == null) continue;
            VersionConstraint versionConstraint = this.requirementFactory.createVersionConstraint();
            if (versionRequirement.startsWith(">=")) {
                versionRequirement = versionRequirement.substring(2);
                versionRange = this.conditionFactory.createVersionRange();
                versionRange.setMinimumVersion(versionRequirement);
                versionRanges = new ArrayList<VersionRange>();
                versionRanges.add(versionRange);
                versionConstraint.setVersionRanges(versionRanges);
            }
            if (versionRequirement.startsWith("=")) {
                versionRequirement = versionRequirement.substring(1);
                VersionValue versionValue = this.conditionFactory.createVersionValue(versionRequirement);
                ArrayList<VersionValue> versionValues = new ArrayList<VersionValue>();
                versionValues.add(versionValue);
                versionConstraint.setVersionValues(versionValues);
            }
            if (versionRequirement.startsWith("<")) {
                boolean includeEqualTo = false;
                if ((versionRequirement = versionRequirement.substring(1)).startsWith("=")) {
                    versionRequirement = versionRequirement.substring(1);
                    includeEqualTo = true;
                }
                versionRequirement = versionRequirement.substring(1);
                VersionRange versionRange2 = this.conditionFactory.createVersionRange();
                versionRange2.setMaximumVersion(versionRequirement);
                versionRange2.setMaximumVersionInclusiveness(Boolean.valueOf(includeEqualTo));
                ArrayList<VersionRange> versionRanges2 = new ArrayList<VersionRange>();
                versionRanges2.add(versionRange2);
                versionConstraint.setVersionRanges(versionRanges2);
            }
            ArrayList<VersionConstraint> versionConstraints = new ArrayList<VersionConstraint>();
            versionConstraints.add(versionConstraint);
            constraint.setVersionConstraintArray(versionConstraints);
        }
        preReqs.setResourceConstraints(preReqsConstraints);
        Requirement rpmReqs = this.requirementFactory.createRequirement("PackageManager");
        ArrayList<String> rpmReqsOperationList = new ArrayList<String>();
        rpmReqsOperationList.add("install");
        rpmReqs.setOperations(rpmReqsOperationList);
        requirements.add(rpmReqs);
        RequirementResourceConstraint rpmConstraint = this.requirementFactory.createRequirementResourceConstraint("rpmConstraint", rpmResource.getResourceID());
        ArrayList<RequirementResourceConstraint> rpmReqsConstraints = new ArrayList<RequirementResourceConstraint>();
        rpmReqsConstraints.add(rpmConstraint);
        VersionConstraint rpmVersionConstraint = this.requirementFactory.createVersionConstraint();
        versionRange = this.conditionFactory.createVersionRange();
        versionRange.setMinimumVersion("3.0");
        versionRanges = new ArrayList();
        versionRanges.add(versionRange);
        rpmVersionConstraint.setVersionRanges(versionRanges);
        rpmReqs.setResourceConstraints(rpmReqsConstraints);
        ResultingResource resultingResource = this.contentUnitFactory.createResultingResource(pkgResource.getResourceID());
        resultingResource.setVersion(String.valueOf(this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_VERSION).getStringData()) + "-" + this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_RELEASE).getStringData());
        ArrayList resultingResources = new ArrayList();
        Artifact installArtifact = this.artifactFactory.createInstallArtifact();
        installArtifact.setContentReference("rpmFile");
        installArtifact.setPackageType("rpm");
        InstallableUnit installableUnit = this.contentUnitFactory.createInstallableUnit(String.valueOf(resultingResource.getResourceReference()) + "_IU", rpmResource.getResourceID(), installArtifact, 0);
        installableUnit.setRequirements(requirements);
        installableUnit.setResultingResources(resultingResources);
        DeploymentDescriptor dd = this.baseFactory.createDeploymentDescriptor(SCHEMA_VERSION, this.generateDescriptorID(), new Date(), (ContentUnit)installableUnit, topology);
        return dd;
    }

    private boolean ignoreRequirement(String requirement) {
        String[] requirements = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_REQUIRENAME).getStringArrayData();
        if (requirement.equals("lsb")) {
            return true;
        }
        if (requirement.equals("rpmlib(VersionedDependencies)")) {
            return true;
        }
        if (requirement.equals("rpmlib(PayloadFilesHavePrefix)")) {
            return true;
        }
        if (requirement.equals("rpmlib(CompressedFileNames)")) {
            return true;
        }
        if (requirement.equals("/bin/sh")) {
            return true;
        }
        String configReq = "config(" + this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_NAME).getStringData() + ")";
        if (requirement.equals(configReq)) {
            return true;
        }
        if (requirement.indexOf("(") != -1) {
            String libName = requirement.substring(0, requirement.indexOf("("));
            int j = 0;
            while (j < requirements.length) {
                if (libName.equals(requirements[j])) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private String findVersionRequirement(Resource requirement) {
        Iterator<Object> keysIter = requirement.getProperties().keySet().iterator();
        String[] versionRequirements = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_REQUIREVERSION).getStringArrayData();
        int[] versionFlags = this.rpmFile.getHeaderEntry(RPMFile.RPMTAG_REQUIREFLAGS).getIntData();
        int index = -1;
        Properties properties = requirement.getProperties();
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            if (!key.equals("rpmRequirenameIndex")) continue;
            index = Integer.parseInt(properties.getProperty(key));
            keysIter.remove();
        }
        String version = versionRequirements[index];
        if (!version.equals("")) {
            if ((versionFlags[index] & RPMFile.RPMSENSE_EQUAL) == RPMFile.RPMSENSE_EQUAL) {
                version = "=" + version;
            }
            if ((versionFlags[index] & RPMFile.RPMSENSE_LESS) == RPMFile.RPMSENSE_LESS) {
                version = "<" + version;
            }
            if ((versionFlags[index] & RPMFile.RPMSENSE_GREATER) == RPMFile.RPMSENSE_GREATER) {
                version = ">" + version;
            }
            return version;
        }
        return null;
    }

    private byte[] generateDescriptorID() {
        byte[] descriptorID = new byte[16];
        Random random = new Random(Calendar.getInstance().getTimeInMillis());
        random.nextBytes(descriptorID);
        return descriptorID;
    }
}

