/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;

public class VersionConstraintType {
	public static VersionConstraint merge(VersionConstraint versionConstraint1, VersionConstraint versionConstraint2){
		
		Collection<VersionRange> certifiedRanges = VersionConstraintValueType.mergeRanges(versionConstraint1.getCertifiedVersionRanges(), versionConstraint2.getCertifiedVersionRanges());
		Collection<VersionRange> supportedRanges = VersionConstraintValueType.mergeRanges(versionConstraint1.getVersionRanges(), versionConstraint2.getVersionRanges());
		
		Collection<VersionValue> certifiedValues = VersionConstraintValueType.mergeValues(versionConstraint1.getCertifiedVersionValues(), versionConstraint2.getCertifiedVersionValues());
		Collection<VersionValue> supportedValues = VersionConstraintValueType.mergeValues(versionConstraint1.getVersionValues(), versionConstraint2.getVersionValues());
		
		versionConstraint1.setCertifiedVersionRanges(certifiedRanges);
		versionConstraint1.setVersionRanges(supportedRanges);
		
		versionConstraint1.setCertifiedVersionValues(certifiedValues);
		versionConstraint1.setVersionValues(supportedValues);
		
		//TODO: need to add merging descriptions later
		//DisplayText versionConstraint1.getDescription()
		
		return versionConstraint1;
		
	}

}
