/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.rpm;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg.rpm.Messages;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm.RPMReader;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataCollector;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.util.BTGLogUtil;
import org.w3c.dom.Document;

public class RPMDataCollector implements IBTGDataCollector {
	private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");//$NON-NLS-1$
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");//$NON-NLS-1$

	public Collection<SDDFragment> collectSDDData(Properties properties) {
		RPMReader rpmReader = null;
		try {
			rpmReader = new RPMReader(properties.getProperty("FileName")); //$NON-NLS-1$
		} catch (MalformedURLException e) {
			consoleLogger.severe(Messages.getString("RPMDataCollector.1")); //$NON-NLS-1$
			consoleLogger.log(Level.INFO, Messages.getString("RPMDataCollector.2"), BTGLogUtil.getMsgLogName());//$NON-NLS-1$
            logger.log(Level.SEVERE, Messages.getString("RPMDataCollector.3"), e); //$NON-NLS-1$
			return (null);
		} catch (IOException e) {
			consoleLogger.severe(Messages.getString("RPMDataCollector.4")); //$NON-NLS-1$
			consoleLogger.log(Level.INFO, Messages.getString("RPMDataCollector.2"), BTGLogUtil.getMsgLogName());//$NON-NLS-1$
            logger.log(Level.SEVERE, Messages.getString("RPMDataCollector.3"), e); //$NON-NLS-1$
			return (null);
		}
		
		Collection<SDDFragment> sddFragments = new ArrayList<SDDFragment>();
		
		// Package Descriptor
		Properties pdProperties = new Properties();
		pdProperties.put("FileName", properties.getProperty("FileName")); //$NON-NLS-1$ //$NON-NLS-2$
		
		PackageDescriptor pd = rpmReader.getPackageDescriptor();
		Document pdDoc = pd.getOwnerDocument();
		sddFragments.add(new SDDFragment(pdDoc, pdProperties));
		
		// Deployment Descriptor
		Properties ddProperties = new Properties();
		ddProperties.put("FileName", properties.getProperty("FileName")); //$NON-NLS-1$ //$NON-NLS-2$
		
		DeploymentDescriptor dd = rpmReader.getDeploymentDescriptor();
		Document ddDoc = dd.getOwnerDocument();
		sddFragments.add(new SDDFragment(ddDoc, ddProperties));
		
		return sddFragments;
	}
	
	public Collection<BTGProperty> getSupportedProperties() {
		Collection<BTGProperty> properties = new ArrayList<BTGProperty>();
		
		// FileName
		properties.add(new BTGProperty("FileName", true)); //$NON-NLS-1$
		
		return properties;
	}
}