/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.export.ui;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLMessages;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLRepositoryManager;
import org.eclipse.cosmos.rm.internal.smlif.export.ui.ExportResourceTreeContentProvider;
import org.eclipse.cosmos.rm.internal.smlif.export.ui.ExportToSMLIFWizardPage;
import org.eclipse.cosmos.rm.internal.smlif.export.ui.ExportToSMLIFWizardPage2;
import org.eclipse.cosmos.rm.internal.smlif.export.ui.ExportToSMLIFWizardPage3;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLMetadata;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToSMLIFWizard
extends Wizard
implements IExportWizard,
ICheckStateListener {
    protected ExportToSMLIFWizardPage mainPage;
    protected ExportToSMLIFWizardPage2 page2;
    protected ExportToSMLIFWizardPage3 page3;
    protected IStructuredSelection selection;
    protected HashMap<IResource, ISMLDocument> selectedFiles = new HashMap();

    public boolean performFinish() {
        return this.mainPage.doExport();
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new ExportToSMLIFWizardPage(SMLMessages.exportWizardPageTitle, this.selection);
        this.mainPage.setDescription(SMLMessages.exportWizardFileInstruction);
        this.addPage((IWizardPage)this.mainPage);
        this.page2 = new ExportToSMLIFWizardPage2(SMLMessages.exportWizardPageTitle, this.selection);
        this.page2.setDescription(SMLMessages.exportWizardDescriptionPageTwo);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new ExportToSMLIFWizardPage3(SMLMessages.exportWizardPageTitle, this.selection);
        this.page3.setDescription(SMLMessages.exportWizardDescriptionPage3);
        this.addPage((IWizardPage)this.page3);
        this.setWindowTitle(SMLMessages.exportWizardTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public ExportToSMLIFWizardPage getMainPage() {
        return this.mainPage;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        IResource file = (IResource)event.getElement();
        if (event.getChecked()) {
            this.addFileToSelected(file);
        } else {
            this.removeFileFromSelected(file);
        }
        this.updateForCheckChange();
    }

    public void allFilesChecked(boolean checked) {
        if (checked) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ExportToSMLIFWizard.this.addFileToSelected((IResource)ExportToSMLIFWizard.this.mainPage.getSelectedProject());
                }
            };
            BusyIndicator.showWhile(null, (Runnable)runnable);
        } else {
            this.selectedFiles.clear();
        }
        this.updateForCheckChange();
    }

    private void updateForCheckChange() {
        this.page2.updateDocumentList();
        this.page2.initDocumentIdentityFields();
        this.page3.updateComboChoices();
        this.mainPage.updatePageComplete();
    }

    protected void addFileToSelected(IResource file) {
        if (file instanceof IContainer) {
            Object[] kids = ((ExportResourceTreeContentProvider)this.mainPage.getFileTree().getContentProvider()).getChildren(file);
            int i = 0;
            while (i < kids.length) {
                this.addFileToSelected((IResource)kids[i]);
                ++i;
            }
            return;
        }
        this.primAddFileToSelected(file);
    }

    protected void primAddFileToSelected(IResource file) {
        if (this.selectedFiles.get(file) == null) {
            try {
                ISMLDocument[] document = SMLRepositoryManager.getRepository(file.getProject().getLocation().toString(), false).fetchDocuments((ISMLMetadata)new SMLFileMetadata(file.getLocation().toString(), -1, null, null, null));
                if (document != null && document.length == 1) {
                    this.selectedFiles.put(file, document[0]);
                }
            }
            catch (RepositoryOperationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void removeFileFromSelected(IResource file) {
        if (file instanceof IContainer) {
            Object[] kids = ((ExportResourceTreeContentProvider)this.mainPage.getFileTree().getContentProvider()).getChildren(file);
            int i = 0;
            while (i < kids.length) {
                this.removeFileFromSelected((IResource)kids[i]);
                ++i;
            }
            return;
        }
        this.primRemoveFileFromSelected(file);
    }

    protected void primRemoveFileFromSelected(IResource file) {
        if (this.selectedFiles.containsKey(file)) {
            this.selectedFiles.remove(file);
        }
    }

    public HashMap<IResource, ISMLDocument> getSelectedFiles() {
        return this.selectedFiles;
    }

    protected static Button createVerticalButtonPanelButton(Composite buttonComposite, String buttonText) {
        Button button = new Button(buttonComposite, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(256);
        buttonData.verticalAlignment = 1;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    protected static Composite createVerticalButtonPanel(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonCompositeData = new GridData();
        buttonCompositeData.verticalAlignment = 4;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        return buttonComposite;
    }

    public ExportToSMLIFWizardPage2 getPage2() {
        return this.page2;
    }
}

