/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.common;


/**
 * Represents an SML-IF identity
 * 
 * @author Ali Mehregani
 */
public class SMLIFIdentity
{
	/**
	 * The ID of the SML-IF document which in the case of the file-system
	 * implementation is the file name of the SML-IF document.
	 */
	private String id;
	
	/**
	 * The name of the SML-IF document
	 */
	private String name;
	
	/**
	 * The description of the SML-IF document
	 */
	private String description;
	
	/**
	 * The display name of the SML-IF document
	 */
	private String displayName;
	
	/**
	 * The version of the SML-IF document
	 */
	private String version;
	
	/**
	 * The base URI of the SML-IF document
	 */
	private String baseURI;

	
	/**
	 * Default constructor
	 */
	public SMLIFIdentity()
	{
		
	}
	
	/**
	 * Convenience constructor
	 */
	public SMLIFIdentity (	String id, String name, 
							String description, String displayName, 
							String version, String baseURI)
	{
		this.id = id;
		this.name = name;
		this.description = description;
		this.displayName = displayName;
		this.version = version;
		this.baseURI = baseURI;
	}
	
	/**
	 * @return the id
	 */
	public String getId()
	{
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id)
	{
		this.id = id;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the description
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName()
	{
		return displayName;
	}

	/**
	 * @param displayName the displayName to set
	 */
	public void setDisplayName(String displayName)
	{
		this.displayName = displayName;
	}

	/**
	 * @return the version
	 */
	public String getVersion()
	{
		return version;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(String version)
	{
		this.version = version;
	}

	/**
	 * @return the baseURI
	 */
	public String getBaseURI()
	{
		return baseURI;
	}

	/**
	 * @param baseURI the baseURI to set
	 */
	public void setBaseURI(String baseURI)
	{
		this.baseURI = baseURI;
	}

	/**
	 * Copies the content of the identity passed in into
	 * this SML-IF identity
	 * 
	 * @param identity The identity to copy to this object
	 */
	public void copy(SMLIFIdentity identity)
	{
		setBaseURI(identity.getBaseURI());
		setDescription(identity.getDescription());
		setDisplayName(identity.getDisplayName());
		setId(identity.getId());
		setName(identity.getName());
		setVersion(identity.getVersion());
	}	
}
