/********************************************************************** 
 * Copyright (c) 2007, 2008 IBM Corporation. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.cosmos.rm.internal.validation.common;

import org.eclipse.osgi.util.NLS;

public class SMLValidationMessages extends NLS 
{

	private static final String BUNDLE_NAME = "org.eclipse.cosmos.rm.internal.validation.common.messages";//$NON-NLS-1$
	
	private SMLValidationMessages() 
	{
		// Do not instantiate
	}
	
	public static String commonColumn;
	public static String commonError;
	public static String commonLine;
	public static String commonNoAlias;
	public static String commonUnknown;
	public static String commonCopy;
	public static String commonAnonymous;
	
	public static String outputLineNumber;
	public static String outputSeverity;
	public static String outputSeverityError;
	public static String outputSeverityWarning;
	public static String outputSeverityInfo;
	public static String outputSystem;
	
	public static String errorMarkerOutput;
	public static String errorReferenceNullURI;
	public static String errorBaseNullURI;
	public static String errorInvalidURI;
	public static String errorMissingExpression;
	public static String errorUnclosedExpression;
	public static String errorCSNotNumber;
	public static String errorMissingContext;
	public static String errorBadContext;
	public static String errorMissingXPathFactory;
	public static String errorMissingXPathInstance;
	public static String errorBadXPathExpression;
	public static String errorMissingNamespace;
	public static String errorBadNSExpression;
	public static String errorBadPrefix;
	public static String errorBadURI;
	public static String errorUnbalancedBracket;
	public static String errorWrongReturnType;
	public static String errorWrongReturnScope;
	public static String errorMissingStructure;
	public static String errorDetermineName;
	public static String errorWrongType;
	public static String errorValidatorInstantiation;
	public static String errorIllegalArguments;
	public static String errorCreatingDocument;
	public static String errorInstantiating;
	public static String errorClassNotFound;
	public static String errorParsingDocument;
	public static String errorMissingFile;	
	public static String errorUnsupportedSAXProperty0;
	public static String errorUnsupportedSAXProperty1;
	public static String errorInvalidArgument;	
	public static String errorNoSelectionTitle;
	public static String errorNoSelection;
	public static String errorMultiProjectSelectionTitle;
	public static String errorMultiProjectSelection;
	public static String errorContentTypeTitle;
	public static String errorContentType;	
	public static String errorValidationTitle;
	public static String errorValidation;
	public static String errorInconsistentReference;
	public static String errorInvalidElementSet;
	public static String errorReferenceResolving;
	public static String errorBadBaseURI;
	public static String errorBadSyntaxURI;	
	public static String errorDuplicateAlias;
	public static String errorAliasHasFragment;
	public static String errorDOMDocument;
	
	public static String warningUnresolvedReference;	
	public static String warningMissingResource;
	public static String warningMissingDocument;
	
	public static String confirmNoErrorTitle;
	public static String confirmNoError;
	
	public static String failedValidationTitle;
	public static String failedValidation;
		
	public static String acyclicUnknown;
	public static String acyclicNoReferenceGraph;
	public static String acyclicNoAcyclicTypeList;
	public static String acyclicBadDerivation;
	public static String acyclicNoInheritanceMap;
	public static String acyclicCycleFound;
	public static String acyclicDetectedCycle;
	public static String acyclicInvalidURI;
	public static String acyclicBadDeclaration;
	
	public static String invalidTargetInstance;
	
	public static String targetElementNotDefined;
	public static String targetElementNotRefType;
	public static String targetRequiredNotRefType;
	public static String targetTypeInvalid;
	public static String targetBadDeclaration;
	public static String targetElementInvalidValue;	
	public static String targetBadDerivation;
	public static String targetInconsistentDeclarations;
	public static String targetTypeInvalidValue;
	public static String unresolvedTargetURI;	
	
	public static String identityMissingField;
	public static String identityXPathError;
	public static String identityDuplicateKey;
	public static String identityMissingReference;
	public static String identityMissingConstraint;
	public static String identityMissingKey;
	public static String identityBadDeclaration;
	public static String identityInvalidNameAttribute;
	public static String identityInvalidElements;
	public static String identityBadReferenceType;	
	public static String identityDuplicateName;
	public static String identityInconsistentDeclarations;
	
	public static String schematronTransformation;
	public static String schematronMissingContext;
	
	public static String validationJob;
	public static String validationTask;
	public static String validationBuildingStructures;
	public static String validationAcyclic;
	public static String validationIdentity;
	public static String validationReferences;
	public static String validationSchematron;
	public static String validationSchema;
	public static String validationTarget;	
	
	public static String validationBaseURI;	
	
	public static String errorBaseURIRelativeRef;
	public static String errorBaseURIHasFragment;
	public static String errorBadAliasURI;		
	public static String errorInvalidURIValue;
	public static String errorNoBaseURIValue;
	public static String errorAliasRelative;
	
	public static String warningNoInstSchBinding;
	public static String warningNoDef;
	public static String warningNoDefNms;
	public static String errorRefNotFound;
	public static String errorInvalidScheme;
	public static String messageNoCauseProvidedInException;	

	static 
	{
		NLS.initializeMessages(BUNDLE_NAME, SMLValidationMessages.class);
	}
}

