/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.OperationsType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionType {
    static void merge(Collection<Completion> newVars, Set<Completion> mergedVars) {
        Iterator<Completion> i = newVars.iterator();
        while (i.hasNext()) {
            boolean matches = false;
            Completion newVar = i.next();
            for (Completion mergedVar : mergedVars) {
                if (!CompletionType.equals(newVar, mergedVar)) continue;
                matches = true;
                CompletionType.merge(newVar, mergedVar);
                break;
            }
            if (matches) continue;
            mergedVars.add(newVar);
        }
    }

    static boolean equals(Completion c1, Completion c2) {
        boolean equals = true;
        equals = equals && StringType.equals(c1.getCompletionType(), c2.getCompletionType());
        equals = equals && OperationsType.equals(c1.getCompletionOperations(), c2.getCompletionOperations());
        Resource rc1 = Util.resolveResourceRef(c1.getCompletionResourceReference());
        Resource rc2 = Util.resolveResourceRef(c2.getCompletionResourceReference());
        equals = equals && ResourceType.equals(rc1, rc2);
        return equals;
    }

    static Completion merge(Completion newCompletion, Completion merged) {
        merged.setDescription(TranslatableStringType.merge(newCompletion.getDescription(), merged.getDescription()));
        merged.setShortDescription(TranslatableStringType.merge(newCompletion.getShortDescription(), merged.getShortDescription()));
        return merged;
    }
}

